/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.actuator;

import com.mojang.serialization.MapCodec;
import mods.railcraft.api.track.ArrowDirection;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SwitchTrackActuatorBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<ArrowDirection> RED_ARROW_DIRECTION = EnumProperty.create((String)"red_flag", ArrowDirection.class);
    public static final EnumProperty<ArrowDirection> WHITE_ARROW_DIRECTION = EnumProperty.create((String)"white_flag", ArrowDirection.class);
    public static final BooleanProperty SWITCHED = BooleanProperty.create((String)"switched");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape BASE_SHAPE = SwitchTrackActuatorBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0);
    private static final VoxelShape POST_SHAPE = SwitchTrackActuatorBlock.box((double)7.0, (double)5.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0);
    private static final VoxelShape NORTH_SOUTH_WINGS_SHAPE = SwitchTrackActuatorBlock.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)3.0, (double)16.0);
    private static final VoxelShape EAST_WEST_WINGS_SHAPE = SwitchTrackActuatorBlock.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)3.0, (double)10.0);
    private static final VoxelShape NORTH_SOUTH_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{NORTH_SOUTH_WINGS_SHAPE, POST_SHAPE});
    private static final VoxelShape EAST_WEST_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{EAST_WEST_WINGS_SHAPE, POST_SHAPE});
    private static final MapCodec<SwitchTrackActuatorBlock> CODEC = SwitchTrackActuatorBlock.simpleCodec(SwitchTrackActuatorBlock::new);

    public SwitchTrackActuatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(RED_ARROW_DIRECTION, (Comparable)((Object)ArrowDirection.NORTH_SOUTH))).setValue(WHITE_ARROW_DIRECTION, (Comparable)((Object)ArrowDirection.EAST_WEST))).setValue((Property)SWITCHED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, RED_ARROW_DIRECTION, WHITE_ARROW_DIRECTION, SWITCHED, WATERLOGGED});
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = level.getFluidState(pos);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.Plane.HORIZONTAL.stream().filter(side -> level.getBlockState(pos.relative(side)).getBlock() instanceof SwitchTrackBlock).findFirst().orElse(context.getHorizontalDirection().getOpposite()))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return levelReader.getBlockState(neighborPos).getBlock() instanceof SwitchTrackBlock ? (BlockState)blockState.setValue((Property)FACING, (Comparable)direction) : blockState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z ? NORTH_SOUTH_SHAPE : EAST_WEST_SHAPE;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        return SwitchTrackActuatorBlock.isSwitched(state) ? 15 : 0;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return SwitchTrackActuatorBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.below());
    }

    public static boolean isSwitched(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)SWITCHED);
    }

    public static void setSwitched(BlockState blockState, Level level, BlockPos blockPos, boolean switched) {
        if ((Boolean)blockState.getValue((Property)SWITCHED) == switched) {
            return;
        }
        level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)SWITCHED, (Comparable)Boolean.valueOf(switched)));
        level.playSound(null, blockPos, switched ? SoundEvents.PISTON_CONTRACT : SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.25f, level.getRandom().nextFloat() * 0.25f + 0.7f);
        Direction.Plane.HORIZONTAL.forEach(direction -> {
            BlockPos neighborPos = blockPos.relative(direction);
            if (level.getBlockState(neighborPos).getBlock() instanceof ComparatorBlock) {
                level.updateNeighborsAt(neighborPos, blockState.getBlock());
            }
        });
    }

    public static ArrowDirection getRedArrowDirection(BlockState blockState) {
        return (ArrowDirection)((Object)blockState.getValue(RED_ARROW_DIRECTION));
    }

    public static ArrowDirection getWhiteArrowDirection(BlockState blockState) {
        return (ArrowDirection)((Object)blockState.getValue(WHITE_ARROW_DIRECTION));
    }

    public static void updateArrowDirections(BlockState blockState, Level level, BlockPos blockPos, ArrowDirection redArrowDirection, ArrowDirection whiteArrowDirection) {
        BlockState newState = blockState;
        boolean changed = false;
        if (SwitchTrackActuatorBlock.getRedArrowDirection(blockState) != redArrowDirection) {
            newState = (BlockState)newState.setValue(RED_ARROW_DIRECTION, (Comparable)((Object)redArrowDirection));
            changed = true;
        }
        if (SwitchTrackActuatorBlock.getWhiteArrowDirection(blockState) != whiteArrowDirection) {
            newState = (BlockState)newState.setValue(WHITE_ARROW_DIRECTION, (Comparable)((Object)whiteArrowDirection));
            changed = true;
        }
        if (changed) {
            level.setBlockAndUpdate(blockPos, newState);
        }
    }
}

