/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.util.FunctionalUtil;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class LocomotiveTrackBlock
extends PoweredOutfittedTrackBlock {
    public static final Property<Locomotive.Mode> LOCOMOTIVE_MODE = EnumProperty.create((String)"locomotive_mode", Locomotive.Mode.class);

    public LocomotiveTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue(LOCOMOTIVE_MODE, (Comparable)((Object)Locomotive.Mode.SHUTDOWN));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LOCOMOTIVE_MODE});
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(state, level, pos, cart);
        if (LocomotiveTrackBlock.isPowered(state)) {
            RollingStock.getOrThrow(cart).train().entities().flatMap(FunctionalUtil.ofType(Locomotive.class)).forEach(locomotive -> locomotive.setMode((Locomotive.Mode)((Object)((Object)state.getValue(LOCOMOTIVE_MODE)))));
        }
    }

    @Override
    protected boolean crowbarWhack(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        Locomotive.Mode mode = LocomotiveTrackBlock.getMode(state);
        Locomotive.Mode newMode = player.isCrouching() ? mode.previous() : mode.next();
        boolean res = level.setBlockAndUpdate(pos, (BlockState)state.setValue(LOCOMOTIVE_MODE, (Comparable)((Object)newMode)));
        MutableComponent currentMode = Component.translatable((String)Translations.Tips.CURRENT_MODE);
        MutableComponent modeDisplay = newMode.getDisplayName().copy().withStyle(ChatFormatting.DARK_PURPLE);
        player.displayClientMessage((Component)currentMode.append(CommonComponents.SPACE).append((Component)modeDisplay), true);
        return res;
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos blockPos) {
        return 8;
    }

    public static Locomotive.Mode getMode(BlockState blockState) {
        return (Locomotive.Mode)((Object)blockState.getValue(LOCOMOTIVE_MODE));
    }
}

