/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.function.Supplier;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.SwitchTrackBlockEntity;
import mods.railcraft.world.level.block.entity.track.TurnoutTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.Nullable;

public class TurnoutTrackBlock
extends SwitchTrackBlock
implements EntityBlock {
    public static final BooleanProperty MIRRORED = BooleanProperty.create((String)"mirrored");

    public TurnoutTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).setValue((Property)MIRRORED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MIRRORED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = super.getStateForPlacement(context);
        BlockPos blockPos = context.getClickedPos();
        return (BlockState)blockState.setValue((Property)MIRRORED, (Comparable)Boolean.valueOf(this.determineMirrored(context.getLevel(), blockPos, TurnoutTrackBlock.getFacing(blockState))));
    }

    private boolean determineMirrored(Level level, BlockPos blockPos, Direction facing) {
        return level.getBlockState(blockPos.relative(facing.getCounterClockWise())).is(BlockTags.RAILS);
    }

    @Override
    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldBlockState, boolean moved) {
        this.adjustShape(state, level, pos);
        super.onPlace(state, level, pos, oldBlockState, moved);
    }

    protected void adjustShape(BlockState blockState, Level level, BlockPos pos) {
        BlockPos north = pos.north();
        BlockPos south = pos.south();
        BlockPos east = pos.east();
        BlockPos west = pos.west();
        if (BaseRailBlock.isRail((Level)level, (BlockPos)north) && BaseRailBlock.isRail((Level)level, (BlockPos)south) && BaseRailBlock.isRail((Level)level, (BlockPos)east) && BaseRailBlock.isRail((Level)level, (BlockPos)west)) {
            return;
        }
        switch (TrackUtil.getRailShapeRaw(blockState)) {
            case EAST_WEST: {
                if (!BaseRailBlock.isRail((Level)level, (BlockPos)north) || !BaseRailBlock.isRail((Level)level, (BlockPos)south)) {
                    return;
                }
                RailShape northShape = TrackUtil.getTrackDirection((BlockGetter)level, north);
                RailShape southShape = TrackUtil.getTrackDirection((BlockGetter)level, south);
                if (!northShape.equals((Object)RailShape.NORTH_SOUTH) || !southShape.equals((Object)RailShape.NORTH_SOUTH)) break;
                TrackUtil.setRailShape(level, pos, RailShape.NORTH_SOUTH);
                break;
            }
            case NORTH_SOUTH: {
                if (!BaseRailBlock.isRail((Level)level, (BlockPos)east) || !BaseRailBlock.isRail((Level)level, (BlockPos)west)) {
                    return;
                }
                RailShape eastShape = TrackUtil.getTrackDirection((BlockGetter)level, east);
                RailShape westShape = TrackUtil.getTrackDirection((BlockGetter)level, west);
                if (!eastShape.equals((Object)RailShape.EAST_WEST) || !westShape.equals((Object)RailShape.EAST_WEST)) break;
                TrackUtil.setRailShape(level, pos, RailShape.EAST_WEST);
                break;
            }
        }
    }

    @Override
    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean moved) {
        level.setBlockAndUpdate(pos, (BlockState)blockState.setValue((Property)MIRRORED, (Comparable)Boolean.valueOf(this.determineMirrored(level, pos, TurnoutTrackBlock.getFacing(blockState)))));
        super.neighborChanged(blockState, level, pos, neighborBlock, orientation, moved);
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        return level.setBlockAndUpdate(pos, (BlockState)((BlockState)blockState.cycle((Property)REVERSED)).cycle((Property)MIRRORED));
    }

    @Override
    public RailShape getRailDirection(BlockState blockState, BlockGetter world, BlockPos pos, @Nullable AbstractMinecart cart) {
        boolean mirrored = TurnoutTrackBlock.isMirrored(blockState);
        if (TurnoutTrackBlock.isSwitched(blockState)) {
            return switch (TurnoutTrackBlock.getFacing(blockState)) {
                case Direction.NORTH -> {
                    if (mirrored) {
                        yield RailShape.SOUTH_WEST;
                    }
                    yield RailShape.SOUTH_EAST;
                }
                case Direction.SOUTH -> {
                    if (mirrored) {
                        yield RailShape.NORTH_EAST;
                    }
                    yield RailShape.NORTH_WEST;
                }
                case Direction.EAST -> {
                    if (mirrored) {
                        yield RailShape.NORTH_WEST;
                    }
                    yield RailShape.SOUTH_WEST;
                }
                case Direction.WEST -> {
                    if (mirrored) {
                        yield RailShape.SOUTH_EAST;
                    }
                    yield RailShape.NORTH_EAST;
                }
                default -> throw new IllegalStateException("Invalid facing direction.");
            };
        }
        return TurnoutTrackBlock.getRailShapeRaw(blockState);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TurnoutTrackBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : BaseEntityBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.TURNOUT_TRACK.get()), SwitchTrackBlockEntity::serverTick);
    }

    public static boolean isMirrored(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)MIRRORED);
    }
}

