/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidStacksResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class StandardTank
extends FluidStacksResourceHandler {
    @Nullable
    protected Supplier<FluidStack> filter;
    private Predicate<FluidResource> validator;
    @Nullable
    private Runnable changeCallback;
    @Nullable
    private Consumer<FluidStack> fillProcessor;
    private boolean disableExtract;
    private boolean disableInsert;
    private List<Component> tooltip;
    private final FluidStackJournal fluidStackJournal = new FluidStackJournal();

    private StandardTank(int capacity) {
        super(1, capacity);
        this.refreshTooltip();
        this.validator = __ -> true;
    }

    public StandardTank fillProcessor(Consumer<FluidStack> fillProcessor) {
        this.fillProcessor = fillProcessor;
        return this;
    }

    public StandardTank filter(TagKey<Fluid> tag) {
        return this.setValidator(fluidResource -> fluidResource.is(tag));
    }

    public StandardTank filter(Fluid filter) {
        return this.filter(() -> filter);
    }

    public StandardTank filter(Supplier<? extends Fluid> filter) {
        this.filter = () -> new FluidStack((Fluid)filter.get(), 1);
        return this.setValidator(fluidResource -> fluidResource.is((Object)((Fluid)filter.get())));
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public FluidStack getFluidStack() {
        return FluidUtil.getStack((ResourceHandler)this, (int)0);
    }

    public int getCapacity() {
        return this.getCapacity(0, FluidResource.EMPTY);
    }

    public int getFluidAmount() {
        return this.getAmountAsInt(0);
    }

    public boolean isEmpty() {
        return this.getFluidAmount() <= 0;
    }

    public boolean isFull() {
        return this.getFluidAmount() == this.getCapacityAsInt(0, (Resource)FluidResource.EMPTY);
    }

    public int getRemainingSpace() {
        return this.getCapacityAsInt(0, (Resource)FluidResource.EMPTY) - this.getFluidAmount();
    }

    public FluidType getFluidType() {
        return this.getFluidStack().getFluidType();
    }

    public void setFluid(FluidStack fluidStack) {
        this.set(0, FluidResource.of((FluidStack)fluidStack), fluidStack.getAmount());
    }

    public StandardTank setValidator(Predicate<FluidResource> validator) {
        this.validator = validator;
        return this;
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.validator.test(resource);
    }

    public int insert(FluidResource resource, int amount, TransactionContext transaction) {
        this.fluidStackJournal.updateSnapshots(transaction);
        return this.disableInsert ? 0 : super.insert((Resource)resource, amount, transaction);
    }

    public int internalInsert(FluidResource resource, int amount, TransactionContext transaction) {
        return super.insert((Resource)resource, amount, transaction);
    }

    public int extract(FluidResource resource, int amount, TransactionContext transaction) {
        return this.disableExtract ? 0 : super.extract((Resource)resource, amount, transaction);
    }

    public int internalExtract(FluidResource resource, int amount, TransactionContext transaction) {
        return super.extract((Resource)resource, amount, transaction);
    }

    public StandardTank disableExtract() {
        this.disableExtract = true;
        return this;
    }

    public StandardTank disableInsert() {
        this.disableInsert = true;
        return this;
    }

    public StandardTank changeCallback(@Nullable Runnable changeCallback) {
        this.changeCallback = changeCallback;
        return this;
    }

    public void set(int index, FluidResource resource, int amount) {
        if (resource.isEmpty() || this.isValid(index, resource)) {
            super.set(index, (Resource)resource, amount);
        }
    }

    protected void onContentsChanged(int index, FluidStack previousContents) {
        this.refreshTooltip();
        if (this.changeCallback != null) {
            this.changeCallback.run();
        }
    }

    public List<Component> getTooltip() {
        return this.tooltip;
    }

    protected void refreshTooltip() {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        int amount = this.getFluidAmount();
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack.isEmpty() && this.filter != null) {
            fluidStack = this.filter.get();
        }
        if (fluidStack.isEmpty()) {
            tooltip.add(Component.translatable((String)Translations.Tips.EMPTY));
        } else {
            tooltip.add(this.getFluidNameToolTip(fluidStack));
        }
        tooltip.add(Component.literal((String)String.format(Locale.ENGLISH, "%,d / %,d", amount, this.getCapacity())).withStyle(ChatFormatting.GRAY));
        this.tooltip = Collections.unmodifiableList(tooltip);
    }

    protected Component getFluidNameToolTip(FluidStack fluidStack) {
        FluidType fluidType = fluidStack.getFluidType();
        Rarity rarity = fluidType.getRarity();
        return fluidStack.getHoverName().copy().withStyle(rarity.getStyleModifier());
    }

    public static StandardTank ofBuckets(int buckets) {
        return StandardTank.ofCapacity(buckets * 1000);
    }

    public static StandardTank ofCapacity(int capacity) {
        return new StandardTank(capacity);
    }

    private class FluidStackJournal
    extends SnapshotJournal<FluidStack> {
        private FluidStackJournal() {
        }

        protected FluidStack createSnapshot() {
            return StandardTank.this.getFluidStack();
        }

        protected void revertToSnapshot(FluidStack snapshot) {
            StandardTank.this.set(0, FluidResource.of((FluidStack)snapshot), snapshot.getAmount());
        }

        protected void onRootCommit(FluidStack originalState) {
            if (StandardTank.this.fillProcessor != null) {
                StandardTank.this.fillProcessor.accept(originalState);
            }
        }
    }
}

