/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.FuelUtil;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.level.block.entity.steamboiler.FluidFueledSteamBoilerBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.steam.FluidFuelProvider;
import mods.railcraft.world.module.SteamBoilerModule;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;

public class FluidFueledSteamBoilerModule
extends SteamBoilerModule<FluidFueledSteamBoilerBlockEntity> {
    protected final StandardTank fuelTank = StandardTank.ofBuckets(16).disableExtract().setValidator(fluidResource -> !fluidResource.isEmpty() && FuelUtil.getFuelValue(fluidResource) > 0.0f);
    private FluidTools.ProcessState fuelProcessState = FluidTools.ProcessState.RESET;

    public FluidFueledSteamBoilerModule(FluidFueledSteamBoilerBlockEntity provider) {
        super(provider, 3);
        this.tankManager.add(this.fuelTank);
        this.fuelTank.changeCallback(() -> ((FluidFueledSteamBoilerBlockEntity)provider).setChanged());
        this.boiler.setFuelProvider(new FluidFuelProvider(this.fuelTank));
    }

    public StandardTank getFuelTank() {
        return this.fuelTank;
    }

    @Override
    protected void processFluidContainers() {
        super.processFluidContainers();
        this.fuelProcessState = FluidTools.processContainer(this.fluidContainer, this.fuelTank, FluidTools.ProcessType.DRAIN_ONLY, this.fuelProcessState);
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        if (!((FluidFueledSteamBoilerBlockEntity)this.provider).isFormed()) {
            return false;
        }
        if (slot == 0) {
            FluidStack fluid = FluidUtil.getFirstStackContained((ItemStack)itemStack);
            if (fluid.isEmpty()) {
                return false;
            }
            return fluid.is(FluidTags.WATER) || FuelUtil.getFuelValue(FluidResource.of((FluidStack)fluid)) > 0.0f;
        }
        return false;
    }
}

