/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.level.block.entity.steamboiler.SteamBoilerBlockEntity;
import mods.railcraft.world.level.block.steamboiler.FireboxBlock;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.TankManager;
import mods.railcraft.world.level.material.steam.SteamBoiler;
import mods.railcraft.world.module.ContainerModule;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.DelegatingResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public abstract class SteamBoilerModule<T extends SteamBoilerBlockEntity>
extends ContainerModule<T> {
    public static final int TANK_WATER = 0;
    public static final int TANK_STEAM = 1;
    public static final int SLOT_LIQUID_INPUT = 0;
    public static final int SLOT_LIQUID_PROCESSING = 1;
    public static final int SLOT_LIQUID_OUTPUT = 2;
    protected final SteamBoiler boiler;
    private final ResourceHandler<ItemResource> itemHandler = new DelegatingResourceHandler<ItemResource>(this, VanillaContainerWrapper.of((Container)this)){

        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            if (index != 0) {
                return 0;
            }
            return super.extract(index, (Resource)resource, amount, transaction);
        }
    };
    protected final TankManager tankManager = new TankManager(new StandardTank[0]);
    private final StandardTank waterTank = StandardTank.ofBuckets(4).fillProcessor(this::checkFill).filter((Fluid)Fluids.WATER);
    private final StandardTank steamTank = StandardTank.ofBuckets(16).filter(RailcraftTags.Fluids.STEAM);
    protected final ContainerMapper fluidContainer = ContainerMapper.make((Container)this.container, 0, 3).ignoreItemChecks();
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private int processTicks;
    private boolean explode;

    public SteamBoilerModule(T provider, int containerSize) {
        super(provider, containerSize);
        this.waterTank.changeCallback(() -> provider.setChanged());
        this.steamTank.changeCallback(() -> provider.setChanged());
        this.tankManager.add(this.waterTank);
        this.tankManager.add(this.steamTank);
        this.waterTank.disableExtract();
        this.steamTank.disableInsert();
        this.boiler = new SteamBoiler(this.waterTank, this.steamTank);
        this.boiler.setChangeListener(() -> provider.syncToClient());
    }

    public StandardTank getWaterTank() {
        return this.waterTank;
    }

    public StandardTank getSteamTank() {
        return this.steamTank;
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }

    public void update(SteamBoilerBlockEntity.Metadata metadata) {
        int capacity = metadata.tanks() * 1000;
        this.tankManager.setCapacity(1, capacity * metadata.steamCapacityPerTank());
        this.tankManager.setCapacity(0, capacity * 4);
        this.boiler.setMaxTemperature(metadata.maxTemperature());
        this.boiler.setTicksPerCycle(metadata.ticksPerCycle());
    }

    private void checkFill(FluidStack waterOriginalState) {
        this.boiler.checkFill(waterOriginalState, () -> {
            this.explode = true;
        });
    }

    public SteamBoiler getBoiler() {
        return this.boiler;
    }

    @Override
    public void serverTick() {
        boolean burning = this.boiler.isBurning();
        if (!((SteamBoilerBlockEntity)this.provider).isMaster()) {
            this.boiler.reduceHeat(1);
            burning = ((SteamBoilerBlockEntity)this.provider).getMembership().flatMap(membership -> ((SteamBoilerBlockEntity)membership.master()).getModule(SteamBoilerModule.class)).map(module -> module.getBoiler().isBurning()).orElse(false);
        }
        Level level = ((SteamBoilerBlockEntity)this.provider).getLevel();
        BlockPos blockPos = ((SteamBoilerBlockEntity)this.provider).getBlockPos();
        BlockState blockState = ((SteamBoilerBlockEntity)this.provider).getBlockState();
        if (blockState.getBlock() instanceof FireboxBlock && burning != (Boolean)blockState.getValue((Property)FireboxBlock.LIT)) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)FireboxBlock.LIT, (Comparable)Boolean.valueOf(burning)));
        }
        if (!((SteamBoilerBlockEntity)this.provider).isMaster()) {
            return;
        }
        SteamBoilerBlockEntity.Metadata metadata = (SteamBoilerBlockEntity.Metadata)((SteamBoilerBlockEntity)this.provider).getCurrentPattern().get().getMetadata();
        if (this.explode) {
            level.explode(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 5.0f + 0.1f * (float)metadata.tanks(), Level.ExplosionInteraction.TNT);
            this.explode = false;
            return;
        }
        this.boiler.tick(level, metadata.tanks());
        if (this.processTicks++ >= 8) {
            this.processTicks = 0;
            this.processFluidContainers();
        }
    }

    protected void processFluidContainers() {
        this.processState = FluidTools.processContainer(this.fluidContainer, this.waterTank, FluidTools.ProcessType.DRAIN_ONLY, this.processState);
    }

    @Override
    public void serialize(ValueOutput valueOutput) {
        super.serialize(valueOutput);
        valueOutput.putChild("tankManager", (ValueIOSerializable)this.tankManager);
        valueOutput.putChild("boiler", (ValueIOSerializable)this.boiler);
        valueOutput.store("processState", FluidTools.ProcessState.CODEC, (Object)this.processState);
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        super.deserialize(valueInput);
        valueInput.readChild("tankManager", (ValueIOSerializable)this.tankManager);
        valueInput.readChild("boiler", (ValueIOSerializable)this.boiler);
        this.processState = valueInput.read("processState", FluidTools.ProcessState.CODEC).orElse(FluidTools.ProcessState.RESET);
    }
}

