/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.Optional;
import java.util.stream.IntStream;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.level.block.entity.SteamOvenBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.CrafterModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.DelegatingResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class SteamOvenModule
extends CrafterModule<SteamOvenBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 9;
    private static final int STEAM_PER_STEP = 500;
    private static final int TOTAL_COOK_TIME = 256;
    private static final int ITEMS_SMELTED = 9;
    protected final StandardTank steamTank = StandardTank.ofBuckets(8).filter(RailcraftTags.Fluids.STEAM);
    private final ContainerMapper inputContainer = ContainerMapper.make(this, 0, 9);
    private final ContainerMapper outputContainer = ContainerMapper.make(this, 9, 9).ignoreItemChecks();
    private final ResourceHandler<ItemResource> itemHandler = new DelegatingResourceHandler<ItemResource>(this, VanillaContainerWrapper.of((Container)this)){

        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            if (index < 9) {
                return 0;
            }
            return super.extract(index, (Resource)resource, amount, transaction);
        }

        public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
            if (index >= 9) {
                return 0;
            }
            return super.insert(index, (Resource)resource, amount, transaction);
        }
    };

    public SteamOvenModule(SteamOvenBlockEntity provider) {
        super(provider, 18);
    }

    @Override
    protected boolean lacksRequirements() {
        return IntStream.range(0, this.inputContainer.getContainerSize()).mapToObj(this.inputContainer::getItem).noneMatch(stack -> this.getRecipe((ItemStack)stack).isPresent());
    }

    private Optional<RecipeHolder<SmeltingRecipe>> getRecipe(ItemStack itemStack) {
        Level level = ((SteamOvenBlockEntity)this.provider).level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.recipeAccess().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(itemStack), (Level)serverLevel);
        }
        return Optional.empty();
    }

    @Override
    protected int calculateDuration() {
        return 256;
    }

    @Override
    protected boolean doProcessStep() {
        try (Transaction tx = Transaction.openRoot();){
            FluidResource steamResource = (FluidResource)this.steamTank.getResource(0);
            if (steamResource.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            int steamExtracted = this.steamTank.extract(steamResource, 500, (TransactionContext)tx);
            if (steamExtracted < 500) {
                boolean bl = false;
                return bl;
            }
            tx.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    protected boolean craftAndPush() {
        int count = 0;
        boolean changed = true;
        boolean smelted = false;
        RegistryAccess registryAccess = ((SteamOvenBlockEntity)this.provider).getLevel().registryAccess();
        while (count < 9 && changed) {
            changed = false;
            for (int slot = 0; slot < 9 && count < 9; ++slot) {
                ItemStack output;
                ItemStack stack = this.inputContainer.getItem(slot);
                if (stack.isEmpty() || (output = this.getRecipe(stack).map(x -> ((SmeltingRecipe)x.value()).assemble(new SingleRecipeInput(stack), (HolderLookup.Provider)registryAccess)).orElse(ItemStack.EMPTY)).isEmpty() || !this.outputContainer.canFit(output) || !this.outputContainer.insert(output).isEmpty()) continue;
                this.inputContainer.removeItem(slot, 1);
                changed = true;
                ++count;
            }
            smelted |= changed;
        }
        if (smelted) {
            ((SteamOvenBlockEntity)this.provider).getLevel().playSound(null, ((SteamOvenBlockEntity)this.provider).blockPos(), (SoundEvent)RailcraftSoundEvents.STEAM_BURST.get(), SoundSource.BLOCKS, 1.0f, ((SteamOvenBlockEntity)this.provider).getLevel().getRandom().nextFloat() * 0.1f + 1.0f);
        }
        return smelted;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index < 9 && super.canPlaceItem(index, stack)) {
            return this.getRecipe(stack).isPresent();
        }
        return super.canPlaceItem(index, stack);
    }

    public StandardTank getSteamTank() {
        return this.steamTank;
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }
}

