/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.concurrent.atomic.AtomicReference;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.ChargeModule;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class SteamTurbineModule
extends ChargeModule<SteamTurbineBlockEntity> {
    private static final int ROTOR_DAMAGE_CHANCE = 200;
    public static final int CHARGE_OUTPUT = 225;
    private static final int STEAM_USAGE = 360;
    public static final int TANK_STEAM = 0;
    public static final int TANK_WATER = 1;
    private final StandardTank steamTank;
    private final StandardTank waterTank;
    private final AdvancedContainer rotorContainer = new AdvancedContainer(1);
    private float operatingRatio;
    private int energy;
    private final ResourceHandler<FluidResource> fluidHandler = new FluidHandler();

    public SteamTurbineModule(SteamTurbineBlockEntity provider, Charge network) {
        super(provider, network);
        this.rotorContainer.listener((RailcraftBlockEntity)this.provider);
        this.steamTank = StandardTank.ofBuckets(4).filter(RailcraftTags.Fluids.STEAM).disableExtract().changeCallback(() -> ((SteamTurbineBlockEntity)provider).setChanged());
        this.waterTank = StandardTank.ofBuckets(4).filter((TagKey<Fluid>)FluidTags.WATER).disableInsert().changeCallback(() -> ((SteamTurbineBlockEntity)provider).setChanged());
    }

    public ResourceHandler<FluidResource> getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        boolean addedEnergy = false;
        if (this.energy < 225 * ((Double)RailcraftConfig.SERVER.turbinePowerMultiplier.get()).intValue() && !this.steamTank.getFluidStack().isEmpty()) {
            try (Transaction tx = Transaction.openRoot();){
                ItemStack rotorStack;
                int steamExtracted = this.steamTank.internalExtract((FluidResource)this.steamTank.getResource(0), 360, (TransactionContext)tx);
                if (steamExtracted >= 360 && (rotorStack = this.rotorContainer.getItem(0)).is((Item)RailcraftItems.TURBINE_ROTOR.get())) {
                    addedEnergy = true;
                    this.energy += 225 * ((Double)RailcraftConfig.SERVER.turbinePowerMultiplier.get()).intValue();
                    this.waterTank.internalInsert(FluidResource.of((Fluid)Fluids.WATER), 2, (TransactionContext)tx);
                    tx.commit();
                    this.rotorContainer.setItem(0, SteamTurbineModule.useRotor((ServerLevel)((SteamTurbineBlockEntity)this.provider).level(), rotorStack));
                }
            }
        }
        boolean thisTick = addedEnergy;
        this.operatingRatio = ((float)thisTick - this.operatingRatio) * 0.05f + this.operatingRatio;
        ChargeStorage chargeStorage = this.storage().get();
        if (!chargeStorage.isFull()) {
            try (Transaction tx = Transaction.openRoot();){
                chargeStorage.insert(this.energy, (TransactionContext)tx);
                tx.commit();
                this.energy = 0;
            }
        }
    }

    public float getOperatingRatio() {
        return this.operatingRatio;
    }

    public Container getRotorContainer() {
        return this.rotorContainer;
    }

    public boolean needsMaintenance() {
        ItemStack rotorStack = this.rotorContainer.getItem(0);
        return rotorStack.isEmpty() || !rotorStack.is((Item)RailcraftItems.TURBINE_ROTOR.get()) || (float)rotorStack.getDamageValue() / (float)rotorStack.getMaxDamage() > 0.75f;
    }

    @Override
    public void serialize(ValueOutput valueOutput) {
        super.serialize(valueOutput);
        valueOutput.putChild("steamTank", (ValueIOSerializable)this.steamTank);
        valueOutput.putChild("waterTank", (ValueIOSerializable)this.waterTank);
        valueOutput.putChild("rotorContainer", (ValueIOSerializable)this.rotorContainer);
        valueOutput.putInt("energy", this.energy);
        valueOutput.putFloat("operatingRatio", this.operatingRatio);
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        super.deserialize(valueInput);
        valueInput.readChild("steamTank", (ValueIOSerializable)this.steamTank);
        valueInput.readChild("waterTank", (ValueIOSerializable)this.waterTank);
        valueInput.readChild("rotorContainer", (ValueIOSerializable)this.rotorContainer);
        this.energy = valueInput.getIntOr("energy", 0);
        this.operatingRatio = valueInput.getFloatOr("operatingRatio", 0.0f);
    }

    private static ItemStack useRotor(ServerLevel level, ItemStack stack) {
        RandomSource random = level.getRandom();
        if (random.nextInt(200) == 0) {
            AtomicReference<ItemStack> result = new AtomicReference<ItemStack>(stack);
            stack.hurtAndBreak(1, level, null, item -> result.set(ItemStack.EMPTY));
            return result.get();
        }
        return stack;
    }

    private class FluidHandler
    implements ResourceHandler<FluidResource> {
        private FluidHandler() {
        }

        public int size() {
            return 2;
        }

        private StandardTank getTank(int index) {
            return index == 0 ? SteamTurbineModule.this.steamTank : SteamTurbineModule.this.waterTank;
        }

        public FluidResource getResource(int index) {
            return (FluidResource)this.getTank(index).getResource(0);
        }

        public long getAmountAsLong(int index) {
            return this.getTank(index).getAmountAsLong(0);
        }

        public long getCapacityAsLong(int index, FluidResource resource) {
            return this.getTank(index).getCapacityAsLong(0, (Resource)resource);
        }

        public boolean isValid(int index, FluidResource resource) {
            return this.getTank(index).isValid(0, resource);
        }

        public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
            return SteamTurbineModule.this.steamTank.insert(index, (Resource)resource, amount, transaction);
        }

        public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
            return SteamTurbineModule.this.waterTank.extract(index, (Resource)resource, amount, transaction);
        }
    }
}

