/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.ContainerModule;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.DelegatingResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class TankModule
extends ContainerModule<TankBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_PROCESS = 1;
    public static final int SLOT_OUTPUT = 2;
    private final StandardTank tank;
    private final ResourceHandler<ItemResource> itemHandler = new DelegatingResourceHandler<ItemResource>(this, VanillaContainerWrapper.of((Container)this)){

        public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
            if (index == 2) {
                return 0;
            }
            return super.extract(index, (Resource)resource, amount, transaction);
        }
    };
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private int processTicks;

    public TankModule(TankBlockEntity provider, StandardTank tank) {
        super(provider, 3);
        this.tank = tank;
    }

    public StandardTank getTank() {
        return this.tank;
    }

    @Override
    public void serverTick() {
        if (this.processTicks++ >= 8) {
            this.processTicks = 0;
            this.processState = FluidTools.processContainer(this, this.tank, FluidTools.ProcessType.DRAIN_THEN_FILL, this.processState);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                if (!this.tank.isEmpty() && FluidTools.isRoomInContainer(stack, this.tank.getFluidStack().getFluid())) break;
                if (FluidUtil.getFirstStackContained((ItemStack)stack).isEmpty()) return false;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        if (!super.canPlaceItem(slot, stack)) return false;
        return true;
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public void serialize(ValueOutput valueOutput) {
        super.serialize(valueOutput);
        valueOutput.putChild("tank", (ValueIOSerializable)this.tank);
        valueOutput.store("processState", FluidTools.ProcessState.CODEC, (Object)this.processState);
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        super.deserialize(valueInput);
        valueInput.readChild("tank", (ValueIOSerializable)this.tank);
        this.processState = valueInput.read("processState", FluidTools.ProcessState.CODEC).orElse(FluidTools.ProcessState.RESET);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeVarInt(this.tank.getCapacity());
        FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)out, (Object)this.tank.getFluidStack());
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.tank.setCapacity(in.readVarInt());
        this.tank.setFluid((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)in));
    }
}

