/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.attachment.RailcraftAttachmentTypes;
import mods.railcraft.charge.ChargeCartStorageImpl;
import mods.railcraft.charge.ChargeProviderImpl;
import mods.railcraft.charge.ZapEffectProviderImpl;
import mods.railcraft.client.ClientManager;
import mods.railcraft.data.RailcraftBlockTagsProvider;
import mods.railcraft.data.RailcraftDamageTypeTagsProvider;
import mods.railcraft.data.RailcraftDataMapProvider;
import mods.railcraft.data.RailcraftDatapackProvider;
import mods.railcraft.data.RailcraftFluidTagsProvider;
import mods.railcraft.data.RailcraftItemTagsProvider;
import mods.railcraft.data.RailcraftLanguageProvider;
import mods.railcraft.data.RailcraftParticleProvider;
import mods.railcraft.data.RailcraftPoiTypeTagsProvider;
import mods.railcraft.data.RailcraftSoundsProvider;
import mods.railcraft.data.RailcraftSpriteSourceProvider;
import mods.railcraft.data.advancements.RailcraftAdvancementProvider;
import mods.railcraft.data.loot.RailcraftLootModifierProvider;
import mods.railcraft.data.loot.RailcraftLootTableProvider;
import mods.railcraft.data.models.RailcraftBlockModelProvider;
import mods.railcraft.data.models.RailcraftItemModelProvider;
import mods.railcraft.data.recipes.RailcraftRecipeProvider;
import mods.railcraft.datamaps.RailcraftDataMaps;
import mods.railcraft.loot.RailcraftLootModifiers;
import mods.railcraft.network.PacketHandler;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.network.to_client.LinkedCartsMessage;
import mods.railcraft.particle.RailcraftParticleTypes;
import mods.railcraft.sounds.RailcraftSoundEvents;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import mods.railcraft.world.effect.RailcraftMobEffects;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.ai.village.poi.RailcraftPoiTypes;
import mods.railcraft.world.entity.npc.RailcraftVillagerProfession;
import mods.railcraft.world.entity.npc.RailcraftVillagerTrades;
import mods.railcraft.world.entity.vehicle.MinecartHandler;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.ChargeMeterItem;
import mods.railcraft.world.item.CrowbarHandler;
import mods.railcraft.world.item.RailcraftCreativeModeTabs;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.BlastFurnaceBlockEntity;
import mods.railcraft.world.level.block.entity.CokeOvenBlockEntity;
import mods.railcraft.world.level.block.entity.ContainerBlockEntity;
import mods.railcraft.world.level.block.entity.CrusherBlockEntity;
import mods.railcraft.world.level.block.entity.PoweredRollingMachineBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.SteamOvenBlockEntity;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import mods.railcraft.world.level.block.entity.WaterTankSidingBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.FluidManipulatorBlockEntity;
import mods.railcraft.world.level.block.entity.steamboiler.SteamBoilerBlockEntity;
import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import mods.railcraft.world.level.block.entity.worldspike.WorldSpikeBlockEntity;
import mods.railcraft.world.level.block.track.TrackTypes;
import mods.railcraft.world.level.gameevent.RailcraftGameEvents;
import mods.railcraft.world.level.levelgen.feature.RailcraftFeatures;
import mods.railcraft.world.level.levelgen.structure.ComponentWorkshop;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructurePieces;
import mods.railcraft.world.level.levelgen.structure.RailcraftStructureTypes;
import mods.railcraft.world.level.material.RailcraftFluidTypes;
import mods.railcraft.world.level.material.RailcraftFluids;
import mods.railcraft.world.signal.TokenRingManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.IMinecartCollisionHandler;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.world.chunk.LoadingValidationCallback;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod(value="railcraft")
public class Railcraft {
    public static final boolean BETA = false;
    public static final TicketController CHUNK_CONTROLLER = new TicketController(RailcraftConstants.rl("ticket_controller"), (LoadingValidationCallback)new WorldSpikeBlockEntity.RailcraftValidationTicket());
    private final MinecartHandler minecartHandler = new MinecartHandler();

    public Railcraft(ModContainer modContainer, Dist dist) {
        NeoForge.EVENT_BUS.register((Object)this);
        RailcraftConfig.registerConfig(modContainer);
        IEventBus modEventBus = modContainer.getEventBus();
        modEventBus.addListener(this::handleRegisterCapabilities);
        modEventBus.addListener(this::buildContents);
        modEventBus.addListener(this::handleGatherData);
        modEventBus.addListener(this::registerChunkControllers);
        if (dist.isClient()) {
            ClientManager.init(modEventBus);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        PacketHandler.register(modEventBus);
        RailcraftEntityTypes.register(modEventBus);
        RailcraftBlocks.register(modEventBus);
        RailcraftItems.register(modEventBus);
        RailcraftMobEffects.register(modEventBus);
        RailcraftCreativeModeTabs.register(modEventBus);
        RailcraftBlockEntityTypes.register(modEventBus);
        TrackTypes.register(modEventBus);
        RailcraftFluids.register(modEventBus);
        RailcraftFluidTypes.register(modEventBus);
        RailcraftMenuTypes.register(modEventBus);
        RailcraftSoundEvents.register(modEventBus);
        RailcraftParticleTypes.register(modEventBus);
        RailcraftRecipeSerializers.register(modEventBus);
        RailcraftRecipeTypes.register(modEventBus);
        RailcraftGameEvents.register(modEventBus);
        RailcraftDataSerializers.register(modEventBus);
        RailcraftPoiTypes.register(modEventBus);
        RailcraftVillagerProfession.register(modEventBus);
        RailcraftLootModifiers.register(modEventBus);
        RailcraftFeatures.register(modEventBus);
        RailcraftStructureTypes.register(modEventBus);
        RailcraftStructurePieces.register(modEventBus);
        RailcraftCriteriaTriggers.register(modEventBus);
        RailcraftAttachmentTypes.register(modEventBus);
        RailcraftDataMaps.register(modEventBus);
        RailcraftDataComponents.register(modEventBus);
    }

    private void handleRegisterCapabilities(RegisterCapabilitiesEvent event) {
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            event.registerEntity(RollingStock.CAPABILITY, entityType, (entity, ctx) -> entity instanceof AbstractMinecart ? (RollingStock)entity.getData((AttachmentType)RailcraftAttachmentTypes.MINECART_ROLLING_STOCK.get()) : null);
        }
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)RailcraftEntityTypes.CARGO_MINECART.get(), (e, side) -> new InvWrapper((Container)e));
        event.registerEntity(Capabilities.ItemHandler.ENTITY_AUTOMATION, (EntityType)RailcraftEntityTypes.CARGO_MINECART.get(), (e, side) -> new InvWrapper((Container)e));
        event.registerEntity(Capabilities.FluidHandler.ENTITY, (EntityType)RailcraftEntityTypes.TANK_MINECART.get(), (e, side) -> e.getTankManager());
        event.registerEntity(Capabilities.EnergyStorage.ENTITY, (EntityType)RailcraftEntityTypes.ENERGY_MINECART.get(), (e, side) -> e.getBatteryCart());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)RailcraftEntityTypes.VOID_CHEST_MINECART.get(), (e, side) -> new InvWrapper((Container)e));
        event.registerEntity(Capabilities.ItemHandler.ENTITY_AUTOMATION, (EntityType)RailcraftEntityTypes.VOID_CHEST_MINECART.get(), (e, side) -> new InvWrapper((Container)e));
        event.registerEntity(Capabilities.EnergyStorage.ENTITY, (EntityType)RailcraftEntityTypes.ELECTRIC_LOCOMOTIVE.get(), (e, side) -> e.getBatteryCart());
        event.registerEntity(Capabilities.FluidHandler.ENTITY, (EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get(), (e, side) -> e.getTankManager());
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get(), (e, side) -> e.getFuelContainer());
        event.registerEntity(Capabilities.ItemHandler.ENTITY_AUTOMATION, (EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get(), (e, side) -> e.getFuelContainer());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.WATER_TANK_SIDING.get(), WaterTankSidingBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.COKE_OVEN.get(), CokeOvenBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.COKE_OVEN.get(), CokeOvenBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_OVEN.get(), SteamOvenBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_OVEN.get(), SteamOvenBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.CRUSHER.get(), CrusherBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.CRUSHER.get(), CrusherBlockEntity::getEnergyCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.BLAST_FURNACE.get(), BlastFurnaceBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_TURBINE.get(), SteamTurbineBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_TURBINE.get(), SteamTurbineBlockEntity::getEnergyCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_BOILER.get(), SteamBoilerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEAM_BOILER.get(), SteamBoilerBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.POWERED_ROLLING_MACHINE.get(), PoweredRollingMachineBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.IRON_TANK.get(), TankBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.STEEL_TANK.get(), TankBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.CART_DISPENSER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.TRAIN_DISPENSER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FLUID_LOADER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FLUID_LOADER.get(), FluidManipulatorBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FLUID_UNLOADER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.FLUID_UNLOADER.get(), FluidManipulatorBlockEntity::getFluidCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.ITEM_LOADER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.ITEM_UNLOADER.get(), ContainerBlockEntity::getItemCap);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RailcraftBlockEntityTypes.VOID_CHEST.get(), ContainerBlockEntity::getItemCap);
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidBucketWrapper(stack), new ItemLike[]{RailcraftItems.CREOSOTE_BUCKET});
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (IBlockCapabilityProvider)Charge.distribution, new Block[]{(Block)RailcraftBlocks.FORCE_TRACK_EMITTER.get(), (Block)RailcraftBlocks.NICKEL_ZINC_BATTERY.get(), (Block)RailcraftBlocks.NICKEL_IRON_BATTERY.get(), (Block)RailcraftBlocks.ZINC_CARBON_BATTERY.get(), (Block)RailcraftBlocks.ZINC_CARBON_BATTERY_EMPTY.get(), (Block)RailcraftBlocks.ZINC_SILVER_BATTERY.get(), (Block)RailcraftBlocks.ZINC_SILVER_BATTERY_EMPTY.get(), (Block)RailcraftBlocks.FRAME.get(), (Block)RailcraftBlocks.POWERED_ROLLING_MACHINE.get()});
    }

    private void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            RailcraftCreativeModeTabs.addToolsAndUtilities(event);
        } else if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            RailcraftCreativeModeTabs.addCombat(event);
        } else if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            RailcraftCreativeModeTabs.addFunctionalBlocks(event);
        }
    }

    private void handleGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        RailcraftBlockTagsProvider blockTags = new RailcraftBlockTagsProvider(packOutput, lookupProvider, fileHelper);
        CompletableFuture blockTagsLookup = blockTags.contentsGetter();
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftItemTagsProvider(packOutput, lookupProvider, blockTagsLookup, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftFluidTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftLootTableProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftAdvancementProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftPoiTypeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftLootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftDamageTypeTagsProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftDatapackProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new RailcraftDataMapProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftBlockModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftLanguageProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftSoundsProvider(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftSpriteSourceProvider(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new RailcraftParticleProvider(packOutput, fileHelper));
    }

    private void registerChunkControllers(RegisterTicketControllersEvent event) {
        event.register(CHUNK_CONTROLLER);
    }

    @SubscribeEvent
    public void handleServerAboutToStart(ServerAboutToStartEvent event) {
        ComponentWorkshop.addVillageStructures(event.getServer().registryAccess());
    }

    @SubscribeEvent
    public void handleServerStarted(ServerStartedEvent event) {
        if (((Boolean)RailcraftConfig.SERVER.solidCarts.get()).booleanValue()) {
            AbstractMinecart.registerCollisionHandler((IMinecartCollisionHandler)this.minecartHandler);
        }
    }

    @SubscribeEvent
    public void handleLevelTick(LevelTickEvent.Post event) {
        ChargeProviderImpl[] chargeProviderImplArray = event.getLevel();
        if (chargeProviderImplArray instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)chargeProviderImplArray;
            for (ChargeProviderImpl provider : ChargeProviderImpl.values()) {
                provider.network(level).tick();
            }
            TokenRingManager.get(level).tick(level);
        }
    }

    @SubscribeEvent
    public void handlePlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.tickCount % 20 == 0) {
                List<LinkedCartsMessage.LinkedCart> linkedCarts = EntitySearcher.findMinecarts().around((Entity)player2).inflate(32.0).stream(player2.level()).map(RollingStock::getOrThrow).map(LinkedCartsMessage.LinkedCart::new).toList();
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new LinkedCartsMessage(linkedCarts), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public void handleEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart cart = (AbstractMinecart)entity;
            Player player = event.getEntity();
            InteractionHand hand = event.getHand();
            ItemStack stack = event.getItemStack();
            if (!stack.isEmpty() && stack.is((Item)RailcraftItems.CHARGE_METER.get())) {
                player.swing(hand);
                if (!player.level().isClientSide()) {
                    Optional.ofNullable((IEnergyStorage)cart.getCapability(Capabilities.EnergyStorage.ENTITY, null)).filter(ChargeCartStorageImpl.class::isInstance).map(ChargeCartStorageImpl.class::cast).ifPresent(battery -> {
                        ChargeMeterItem.sendCartStat(player, cart.getDisplayName(), battery);
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                    });
                }
            } else {
                event.setCanceled(this.minecartHandler.handleInteract(cart, player));
                InteractionResult crowbarActionResult = CrowbarHandler.handleInteract(cart, player, hand);
                if (crowbarActionResult.consumesAction()) {
                    event.setCanceled(true);
                    event.setCancellationResult(crowbarActionResult);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEntityLeaveWorld(EntityLeaveLevelEvent event) {
        AbstractMinecart cart;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractMinecart && !(cart = (AbstractMinecart)entity).level().isClientSide() && cart.isRemoved()) {
            RollingStock.getOrThrow(cart).removed(cart.getRemovalReason());
        }
    }

    @SubscribeEvent
    public void handleLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ChargeProviderImpl.DISTRIBUTION.removeChargeNetwork(level);
        }
    }

    @SubscribeEvent
    public void modifyDrops(LivingDropsEvent event) {
        Level level = event.getEntity().level();
        RegistryAccess registryAccess = level.registryAccess();
        if (event.getSource().equals((Object)RailcraftDamageSources.steam(registryAccess))) {
            RecipeManager recipeManager = level.getRecipeManager();
            for (ItemEntity entityItem : event.getDrops()) {
                ItemStack drop = entityItem.getItem();
                ItemStack cooked = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(drop), level).map(x -> ((SmeltingRecipe)x.value()).getResultItem((HolderLookup.Provider)registryAccess)).orElse(ItemStack.EMPTY);
                if (cooked.isEmpty() || !level.getRandom().nextBoolean()) continue;
                entityItem.setItem(new ItemStack((ItemLike)cooked.getItem(), drop.getCount()));
            }
        }
    }

    @SubscribeEvent
    public void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == RailcraftVillagerProfession.TRACKMAN.get()) {
            RailcraftVillagerTrades.addTradeForTrackman((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == RailcraftVillagerProfession.CARTMAN.get()) {
            RailcraftVillagerTrades.addTradeForCartman((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == VillagerProfession.ARMORER) {
            RailcraftVillagerTrades.addTradeForArmorer((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        } else if (event.getType() == VillagerProfession.TOOLSMITH) {
            RailcraftVillagerTrades.addTradeForToolSmith((Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades());
        }
    }

    @SubscribeEvent
    public void handleNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        event.getLevel().gameEvent(null, RailcraftGameEvents.NEIGHBOR_NOTIFY, event.getPos());
    }

    static {
        Charge._setZapEffectProvider(new ZapEffectProviderImpl());
        for (ChargeProviderImpl value : ChargeProviderImpl.values()) {
            value.getCharge()._setProvider(value);
        }
    }
}

