/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.charge;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import mods.railcraft.api.charge.ChargeStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public enum Charge implements StringRepresentable,
IBlockCapabilityProvider<IEnergyStorage, Direction>
{
    distribution("distribution");

    private static ZapEffectProvider zapEffectProvider;
    private final String name;
    private Provider provider;

    private Charge(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @ApiStatus.Internal
    public void _setProvider(Provider provider) {
        Preconditions.checkState((this.provider == null ? 1 : 0) != 0, (Object)"provider already set.");
        this.provider = provider;
    }

    public Network network(ServerLevel level) {
        Objects.requireNonNull(this.provider);
        return this.provider.network(level);
    }

    public final ChargeStorage getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable Direction context) {
        ChargeStorage chargeStorage;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            chargeStorage = this.network(serverLevel).access(pos).storage().orElse(null);
        } else {
            chargeStorage = null;
        }
        return chargeStorage;
    }

    public static ZapEffectProvider zapEffectProvider() {
        Objects.requireNonNull(zapEffectProvider);
        return zapEffectProvider;
    }

    @ApiStatus.Internal
    public static void _setZapEffectProvider(ZapEffectProvider zapEffectProvider) {
        Preconditions.checkState((Charge.zapEffectProvider == null ? 1 : 0) != 0, (Object)"zapEffectProvider already set.");
        Charge.zapEffectProvider = zapEffectProvider;
    }

    public static interface Provider {
        public Network network(ServerLevel var1);
    }

    public static interface Network {
        public boolean addNode(BlockPos var1, BlockState var2);

        public void removeNode(BlockPos var1);

        public Access access(BlockPos var1);
    }

    public static interface Access {
        default public boolean hasCapacity(int amount) {
            return false;
        }

        default public boolean useCharge(int amount, boolean simulate) {
            return false;
        }

        default public int removeCharge(int amount, boolean simulate) {
            return 0;
        }

        default public Optional<? extends ChargeStorage> storage() {
            return Optional.empty();
        }

        default public int getComparatorOutput() {
            return 0;
        }

        default public void zap(Entity entity, DamageOrigin origin, float damage) {
        }
    }

    public static interface ZapEffectProvider {
        default public void throwSparks(BlockState state, Level level, BlockPos pos, RandomSource rand, int chance) {
        }

        default public void zapEffectPoint(Level level, double x, double y, double z) {
        }

        default public void zapEffectSurface(BlockState state, Level level, BlockPos pos) {
        }

        default public void zapEffectDeath(Level level, double x, double y, double z) {
        }
    }

    public static enum DamageOrigin {
        BLOCK,
        TRACK;

    }
}

