/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory.widget;

import java.util.List;
import mods.railcraft.client.gui.screen.inventory.WidgetRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.gui.widget.FluidGaugeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidGaugeRenderer
extends WidgetRenderer<FluidGaugeWidget> {
    public FluidGaugeRenderer(FluidGaugeWidget widget) {
        super(widget);
    }

    @Override
    public List<Component> getTooltip() {
        return ((FluidGaugeWidget)this.widget).getTooltip();
    }

    @Override
    public void render(ResourceLocation widgetLocation, GuiGraphics guiGraphics, int centreX, int centreY, int mouseX, int mouseY) {
        if (((FluidGaugeWidget)this.widget).tank == null) {
            return;
        }
        FluidStack fluidStack = ((FluidGaugeWidget)this.widget).tank.getFluid();
        if (fluidStack.getAmount() <= 0) {
            return;
        }
        TextureAtlasSprite fluidIcon = FluidRenderer.getFluidTexture(fluidStack, FluidRenderer.FluidType.STILL);
        if (fluidIcon == null) {
            return;
        }
        float scale = (float)Math.min(fluidStack.getAmount(), ((FluidGaugeWidget)this.widget).tank.getCapacity()) / (float)((FluidGaugeWidget)this.widget).tank.getCapacity();
        int color = RenderUtil.getColorARGB(fluidStack);
        float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
        float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        for (int col = 0; col < ((FluidGaugeWidget)this.widget).w / 16; ++col) {
            for (int row = 0; row <= ((FluidGaugeWidget)this.widget).h / 16; ++row) {
                guiGraphics.blit(centreX + ((FluidGaugeWidget)this.widget).x + col * 16, centreY + ((FluidGaugeWidget)this.widget).y + row * 16 - 1, 0, 16, 16, fluidIcon, red, green, blue, alpha);
            }
        }
        int mask = Mth.floor((float)((float)((FluidGaugeWidget)this.widget).h * scale));
        if (mask == 0 && fluidStack.getAmount() > 0) {
            mask = 1;
        }
        guiGraphics.blit(widgetLocation, centreX + ((FluidGaugeWidget)this.widget).x, centreY + ((FluidGaugeWidget)this.widget).y - 1, ((FluidGaugeWidget)this.widget).x, ((FluidGaugeWidget)this.widget).y - 1, ((FluidGaugeWidget)this.widget).w, ((FluidGaugeWidget)this.widget).h - mask + 1);
        guiGraphics.blit(widgetLocation, centreX + ((FluidGaugeWidget)this.widget).x, centreY + ((FluidGaugeWidget)this.widget).y, ((FluidGaugeWidget)this.widget).u, ((FluidGaugeWidget)this.widget).v, ((FluidGaugeWidget)this.widget).w, ((FluidGaugeWidget)this.widget).h);
    }
}

