/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import mods.railcraft.api.signal.SignalUtil;
import mods.railcraft.client.particle.DimmableParticle;
import mods.railcraft.particle.TuningAuraParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class TuningAuraParticle
extends DimmableParticle {
    private final Vec3 destination;
    private final Vec3 source;

    private TuningAuraParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, TuningAuraParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.destination = options.destination();
        this.source = new Vec3(x, y, z);
        this.calculateVector();
        this.scale(0.5f);
        int color = options.color();
        float variant = this.random.nextFloat() * 0.6f + 0.4f;
        this.rCol = (float)FastColor.ARGB32.red((int)color) / 255.0f * variant;
        this.gCol = (float)FastColor.ARGB32.green((int)color) / 255.0f * variant;
        this.bCol = (float)FastColor.ARGB32.blue((int)color) / 255.0f * variant;
        this.setLifetime(2000);
        this.hasPhysics = false;
        this.pickSprite(sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private void calculateVector() {
        Vec3 vecParticle = new Vec3(this.x, this.y, this.z);
        Vec3 vel = this.destination.subtract(vecParticle);
        vel = vel.normalize();
        float velScale = 0.1f;
        this.xd = vel.x * (double)velScale;
        this.yd = vel.y * (double)velScale;
        this.zd = vel.z * (double)velScale;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!SignalUtil.tuningAuraHandler().isTuningAuraActive()) {
            this.remove();
            return;
        }
        if (!this.level.isLoaded(BlockPos.containing((Position)this.source)) || !this.level.isLoaded(BlockPos.containing((Position)this.destination))) {
            this.remove();
        }
        BlockEntity sourceBE = this.level.getBlockEntity(BlockPos.containing((Position)this.source));
        BlockEntity destBE = this.level.getBlockEntity(BlockPos.containing((Position)this.source));
        if (sourceBE == null || sourceBE.isRemoved() || destBE == null || destBE.isRemoved()) {
            this.remove();
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if (this.destination.distanceToSqr(this.x, this.y, this.z) <= 0.3) {
            this.remove();
            return;
        }
        this.calculateVector();
        this.move(this.xd, this.yd, this.zd);
    }

    public static class Provider
    implements ParticleProvider<TuningAuraParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(TuningAuraParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new TuningAuraParticle(level, x, y, z, dx, dy, dz, options, this.sprites);
        }
    }
}

