/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import mods.railcraft.client.util.LineRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.network.to_client.LinkedCartsMessage;
import mods.railcraft.world.item.GogglesItem;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.SharedConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ShuntingAuraRenderer {
    private Collection<LinkedCartsMessage.LinkedCart> linkedCarts;

    public void clearCarts() {
        this.linkedCarts = null;
    }

    public void setLinkedCarts(Collection<LinkedCartsMessage.LinkedCart> linkedCarts) {
        this.linkedCarts = linkedCarts;
    }

    public void render(PoseStack poseStack, Camera mainCamera, float partialTick) {
        GogglesItem.Aura aura;
        if (this.linkedCarts == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack goggles = player.getItemBySlot(EquipmentSlot.HEAD);
        if (goggles.is((Item)RailcraftItems.GOGGLES.get()) && (aura = GogglesItem.getAura(goggles)) == GogglesItem.Aura.SHUNTING) {
            poseStack.pushPose();
            Vec3 projectedView = mainCamera.getPosition();
            poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
            Level level = player.level();
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            for (LinkedCartsMessage.LinkedCart linkedCart : this.linkedCarts) {
                Entity entity = level.getEntity(linkedCart.entityId());
                if (!(entity instanceof AbstractMinecart)) continue;
                AbstractMinecart cart = (AbstractMinecart)entity;
                if (linkedCart.trainId().isEmpty()) continue;
                if (SharedConstants.IS_RUNNING_IN_IDE) {
                    this.renderCartDebugName(cart, poseStack, (MultiBufferSource)bufferSource);
                }
                LineRenderer renderer = LineRenderer.simple((MultiBufferSource)bufferSource);
                int color = RenderUtil.replaceAlpha(linkedCart.trainId().hashCode(), 255);
                Vec3 cartPosition = cart.getPosition(partialTick);
                renderer.renderLine(poseStack, color, cartPosition, cartPosition.add(0.0, 2.0, 0.0));
                this.renderLink(level, cartPosition, linkedCart.linkAId(), color, partialTick, renderer, poseStack);
                this.renderLink(level, cartPosition, linkedCart.linkBId(), color, partialTick, renderer, poseStack);
                bufferSource.endBatch(RenderType.lines());
            }
            poseStack.popPose();
        }
    }

    private void renderCartDebugName(AbstractMinecart minecart, PoseStack poseStack, MultiBufferSource bufferSource) {
        String text = String.valueOf(minecart.getId());
        Vec3 position = minecart.position();
        Font font = Minecraft.getInstance().font;
        float length = -font.width(text) / 2;
        poseStack.pushPose();
        poseStack.translate(position.x, position.y + 2.2, position.z);
        poseStack.mulPose(Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        font.drawInBatch(text, length, 0.0f, -65536, false, matrix4f, bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poseStack.popPose();
    }

    private void renderLink(Level level, Vec3 cartPosition, int cartId, int color, float partialTick, LineRenderer renderer, PoseStack poseStack) {
        if (cartId == -1) {
            return;
        }
        Entity cartA = level.getEntity(cartId);
        if (cartA == null) {
            return;
        }
        Vec3 cartAPosition = cartA.getPosition(partialTick);
        renderer.renderLine(poseStack, color, cartAPosition.add(0.0, 1.5, 0.0), cartPosition.add(0.0, 2.0, 0.0));
    }
}

