/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.renderer.blockentity.AbstractSignalRenderer;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import mods.railcraft.world.level.block.entity.signal.DualSignalBlockEntity;
import mods.railcraft.world.level.block.signal.SignalBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;

public final class DualSignalRenderer<T extends AbstractSignalBlockEntity>
extends AbstractSignalRenderer<T> {
    @Override
    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        Direction direction = (Direction)blockEntity.getBlockState().getValue((Property)SignalBlock.FACING);
        poseStack.pushPose();
        double zOffset = -0.175;
        poseStack.translate(zOffset * (double)direction.getStepX(), 0.0, zOffset * (double)direction.getStepZ());
        SignalAspect signalAspect = ((AbstractSignalBlockEntity)blockEntity).getPrimarySignalAspect().getDisplayAspect();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.19f, 0.0f);
        this.renderSignalAspect(poseStack, bufferSource, packedLight, packedOverlay, signalAspect, direction);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.19f, 0.0f);
        signalAspect = ((DualSignalBlockEntity)blockEntity).getSecondarySignalAspect().getDisplayAspect();
        this.renderSignalAspect(poseStack, bufferSource, packedLight, packedOverlay, signalAspect, direction);
        poseStack.popPose();
        poseStack.popPose();
    }
}

