/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.railcraft.api.carts.Routable;
import mods.railcraft.season.Seasons;
import mods.railcraft.world.entity.vehicle.Directional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public abstract class CustomMinecartRenderer<T extends AbstractMinecart>
extends EntityRenderer<T> {
    public CustomMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T cart, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        boolean ghostTrain;
        Routable routable;
        String dest;
        String customName;
        poseStack.pushPose();
        long i = (long)cart.getId() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.translate(f, f1, f2);
        double d0 = Mth.lerp((double)partialTicks, (double)((AbstractMinecart)cart).xOld, (double)cart.getX());
        double d1 = Mth.lerp((double)partialTicks, (double)((AbstractMinecart)cart).yOld, (double)cart.getY());
        double d2 = Mth.lerp((double)partialTicks, (double)((AbstractMinecart)cart).zOld, (double)cart.getZ());
        Vec3 vector3d = cart.getPos(d0, d1, d2);
        float pitch = Mth.lerp((float)partialTicks, (float)((AbstractMinecart)cart).xRotO, (float)cart.getXRot());
        if (vector3d != null) {
            Vec3 vector3d1 = cart.getPosOffs(d0, d1, d2, (double)0.3f);
            Vec3 vector3d2 = cart.getPosOffs(d0, d1, d2, (double)-0.3f);
            if (vector3d1 == null) {
                vector3d1 = vector3d;
            }
            if (vector3d2 == null) {
                vector3d2 = vector3d;
            }
            poseStack.translate(vector3d.x - d0, (vector3d1.y + vector3d2.y) / 2.0 - d1, vector3d.z - d2);
            Vec3 vector3d3 = vector3d2.add(-vector3d1.x, -vector3d1.y, -vector3d1.z);
            if (vector3d3.length() != 0.0) {
                vector3d3 = vector3d3.normalize();
                yaw = (float)(Math.atan2(vector3d3.z, vector3d3.x) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(vector3d3.y) * 73.0);
            }
        }
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        yaw += 360.0f;
        float serverYaw = cart.getYRot();
        serverYaw += 180.0f;
        if ((serverYaw %= 360.0f) < 0.0f) {
            serverYaw += 360.0f;
        }
        if (Math.abs(yaw - (serverYaw += 360.0f)) > 90.0f) {
            yaw += 180.0f;
            pitch = -pitch;
        }
        if (cart instanceof Directional) {
            Directional directional = (Directional)cart;
            directional.setRenderYaw(yaw);
        }
        poseStack.translate(0.0f, 0.375f, 0.0f);
        boolean renderName = false;
        if (cart.hasCustomName() && !"Ghost Train".equals(customName = cart.getCustomName().getString()) && !"Polar Express".equals(customName)) {
            this.renderNameTag((Entity)cart, cart.getCustomName(), poseStack, bufferSource, packedLight, partialTicks);
            renderName = true;
        }
        if (cart instanceof Routable && !StringUtils.isBlank((CharSequence)(dest = (routable = (Routable)cart).getDestination()))) {
            poseStack.pushPose();
            if (renderName) {
                poseStack.translate(0.0f, 0.3f, 0.0f);
            }
            MutableComponent destination = Component.literal((String)dest).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC});
            this.renderNameTag((Entity)cart, (Component)destination, poseStack, bufferSource, packedLight, partialTicks);
            poseStack.popPose();
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.mulPose(Axis.ZP.rotationDegrees(-pitch));
        float roll = (float)cart.getHurtTime() - partialTicks;
        float damage = cart.getDamage() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (roll > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)roll) * roll * damage / 10.0f * (float)cart.getHurtDir()));
        }
        float colorIntensity = (ghostTrain = Seasons.isGhostTrain(cart)) ? 0.5f : 1.0f;
        this.renderBody(cart, partialTicks, poseStack, bufferSource, packedLight, FastColor.ARGB32.colorFromFloat((float)(ghostTrain ? 0.8f : 1.0f), (float)colorIntensity, (float)colorIntensity, (float)colorIntensity));
        if (ghostTrain) {
            poseStack.pushPose();
            float scale = 1.1f;
            poseStack.scale(scale, scale, scale);
            this.renderBody(cart, partialTicks, poseStack, bufferSource, packedLight, FastColor.ARGB32.colorFromFloat((float)0.4f, (float)1.0f, (float)1.0f, (float)1.0f));
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    protected abstract void renderBody(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);
}

