/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.integrations.jei.recipe.FluidBoilerJEIRecipe;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.material.RailcraftFluids;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public class FluidBoilerRecipeCategory
extends AbstractRecipeCategory<FluidBoilerJEIRecipe> {
    public static final int WIDTH = 117;
    public static final int HEIGHT = 54;
    public static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/fluid_fueled_steam_boiler.png");
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable heatBackground;
    private final IDrawable heatOverlay;
    private final IDrawable flame;

    public FluidBoilerRecipeCategory(IGuiHelper guiHelper) {
        super(RecipeTypes.FLUID_BOILER, (Component)Component.translatable((String)Translations.Jei.FLUID_BOILER), guiHelper.createDrawableItemLike((ItemLike)RailcraftItems.FLUID_FUELED_FIREBOX.get()), 117, 54);
        this.tankBackground = guiHelper.createDrawable(BACKGROUND, 16, 22, 18, 49);
        this.tankOverlay = guiHelper.createDrawable(BACKGROUND, 176, 0, 16, 47);
        this.heatBackground = guiHelper.createDrawable(BACKGROUND, 39, 24, 8, 45);
        this.heatOverlay = guiHelper.createDrawable(BACKGROUND, 176, 61, 6, 43);
        this.flame = guiHelper.createAnimatedRecipeFlame(200);
    }

    public void draw(FluidBoilerJEIRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.heatBackground.draw(guiGraphics, 23, 5);
        this.heatOverlay.draw(guiGraphics, 24, 6);
        this.flame.draw(guiGraphics, 46, 19);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, FluidBoilerJEIRecipe recipe, IFocusGroup focuses) {
        String text = recipe.temperature() + "\u00b0C";
        builder.addText((FormattedText)Component.literal((String)text), 107, 50).setTextAlignment(VerticalAlignment.BOTTOM).setTextAlignment(HorizontalAlignment.CENTER).setColor(-8355712);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidBoilerJEIRecipe recipe, IFocusGroup focuses) {
        builder.addOutputSlot(1, 4).addFluidStack(recipe.steam(), 1000L).setFluidRenderer(1000L, true, 16, 47).setOverlay(this.tankOverlay, 0, 0).setBackground(this.tankBackground, -1, -1);
        ((IRecipeSlotBuilder)builder.addInputSlot(73, 4).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Stream.of(recipe.fuel().getStacks()).map(x -> x.copyWithAmount(1000)).toList())).setFluidRenderer(1000L, true, 16, 47).setOverlay(this.tankOverlay, 0, 0).setBackground(this.tankBackground, -1, -1);
        builder.addInputSlot(100, 4).addFluidStack(recipe.water(), 1000L).setFluidRenderer(1000L, true, 16, 47).setOverlay(this.tankOverlay, 0, 0).setBackground(this.tankBackground, -1, -1);
    }

    public static List<FluidBoilerJEIRecipe> getBoilerRecipes() {
        return List.of(new FluidBoilerJEIRecipe(FluidIngredient.tag(RailcraftTags.Fluids.CREOSOTE), (Fluid)Fluids.WATER, (Fluid)RailcraftFluids.STEAM.get(), 100));
    }
}

