/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.effect;

import mods.railcraft.world.damagesource.RailcraftDamageSources;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class CreosoteEffect
extends MobEffect {
    protected CreosoteEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.level() instanceof ServerLevel && livingEntity.getType().is(EntityTypeTags.ARTHROPOD)) {
            RegistryAccess registryAccess = livingEntity.level().registryAccess();
            livingEntity.hurt((DamageSource)RailcraftDamageSources.creosote(registryAccess), (float)Math.pow(1.1, amplifier));
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int t = 25 >> amplifier;
        return t == 0 || duration % t == 0;
    }
}

