/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.npc;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class RailcraftVillagerTrades {
    public static void addTradeForTrackman(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer(Items.COAL, 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer((Item)RailcraftItems.COAL_COKE.get(), 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.RAIL, 30, 34), new Offer(Items.EMERALD, 2, 3)));
        ((List)trades.get(2)).add(new TrackKitTrade());
        ((List)trades.get(2)).add(new TrackKitTrade());
        ((List)trades.get(3)).add(new TrackKitTrade());
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.STEEL_CROWBAR.get()), new Offer(Items.EMERALD, 24, 52)).setUse(t -> 3));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.WHISTLE_TUNER.get()), new Offer(Items.EMERALD, 1, 2)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.SIGNAL_BLOCK_SURVEYOR.get()), new Offer(Items.EMERALD, 6, 8)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.SIGNAL_TUNER.get()), new Offer(Items.EMERALD, 6, 8)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.GOGGLES.get()), new Offer(Items.EMERALD, 4, 8)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.OVERALLS.get()), new Offer(Items.EMERALD, 19, 32)).setUse(t -> 3));
    }

    public static void addTradeForCartman(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer(Items.COAL, 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer((Item)RailcraftItems.COAL_COKE.get(), 8, 12)));
        ((List)trades.get(2)).add(new CartTrade(false, 4, 7));
        ((List)trades.get(2)).add(new CartTrade(false, 4, 7));
        ((List)trades.get(3)).add(new CartTrade(false, 3, 5));
        ((List)trades.get(3)).add(new CartTrade(true, 30, 40));
        ((List)trades.get(3)).add(new CartTrade(true, 30, 40));
    }

    public static void addTradeForToolSmith(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer(Items.COAL, 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer((Item)RailcraftItems.COAL_COKE.get(), 8, 12)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer(Items.IRON_INGOT, 7, 9)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer((Item)RailcraftItems.STEEL_INGOT.get()), new Offer(Items.EMERALD, 1, 2), new Offer(Items.IRON_INGOT)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer((Item)RailcraftItems.STEEL_INGOT.get()), new Offer(Items.EMERALD, 3, 4)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer((Item)RailcraftItems.SLAG.get(), 1, 2), new Offer(Items.EMERALD, 2, 4)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.STEEL_GEAR.get()), new Offer(Items.EMERALD, 9, 16)));
    }

    public static void addTradeForArmorer(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer(Items.COAL, 16, 24)));
        ((List)trades.get(1)).add(new GenericTrade(new Offer((Item)RailcraftItems.COAL_COKE.get(), 4, 6), new Offer(Items.EMERALD)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer(Items.COPPER_INGOT, 7, 9)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer((Item)RailcraftItems.TIN_INGOT.get(), 7, 9)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer((Item)RailcraftItems.ZINC_INGOT.get(), 7, 9)));
        ((List)trades.get(2)).add(new GenericTrade(new Offer(Items.EMERALD), new Offer((Item)RailcraftItems.NICKEL_INGOT.get(), 7, 9)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.BRASS_INGOT.get()), new Offer(Items.EMERALD, 2, 3)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.BRONZE_INGOT.get()), new Offer(Items.EMERALD, 2, 3)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.INVAR_INGOT.get()), new Offer(Items.EMERALD, 2, 3)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.BRONZE_GEAR.get()), new Offer(Items.EMERALD, 6, 12)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.BRASS_GEAR.get()), new Offer(Items.EMERALD, 6, 12)));
        ((List)trades.get(3)).add(new GenericTrade(new Offer((Item)RailcraftItems.INVAR_GEAR.get()), new Offer(Items.EMERALD, 6, 12)));
    }

    private static class GenericTrade
    implements VillagerTrades.ItemListing {
        private static final ToIntFunction<GenericTrade> USE_SETTER = t -> 7;
        private static final BiFunction<ItemStack, RandomSource, ItemStack> DEFAULT_ENCHANTER = (stack, rand) -> stack;
        private final Offer sale;
        private final Offer[] offers;
        private ToIntFunction<GenericTrade> maxUseSetter;
        private BiFunction<ItemStack, RandomSource, ItemStack> enchanter;

        public GenericTrade(Offer sale, Offer ... offers) {
            this.sale = sale;
            this.offers = offers;
            this.maxUseSetter = USE_SETTER;
            this.enchanter = DEFAULT_ENCHANTER;
        }

        public MerchantOffer getOffer(Entity trader, RandomSource random) {
            ItemCost sellStack = this.prepareStack(random, this.sale);
            ItemCost buyStack1 = this.prepareStack(random, this.offers[0]);
            Optional<Object> buyStack2 = Optional.ofNullable(this.offers.length >= 2 ? this.prepareStack(random, this.offers[1]) : null);
            return new MerchantOffer(buyStack1, buyStack2, this.enchanter.apply(sellStack.itemStack(), random), 12, 15, (float)this.maxUseSetter.applyAsInt(this));
        }

        GenericTrade setUse(ToIntFunction<GenericTrade> f) {
            this.maxUseSetter = f;
            return this;
        }

        GenericTrade setEnchanter(BiFunction<ItemStack, RandomSource, ItemStack> enchanter) {
            this.enchanter = enchanter;
            return this;
        }

        private ItemCost prepareStack(RandomSource random, Offer offer) {
            return new ItemCost((ItemLike)offer.item, this.stackSize(random, offer));
        }

        private int stackSize(RandomSource random, Offer offer) {
            return random.nextIntBetweenInclusive(offer.min, offer.max);
        }
    }

    private static class Offer {
        private final Item item;
        private final int min;
        private final int max;

        private Offer(Item item, int min, int max) {
            this.item = item;
            this.min = min;
            this.max = max;
        }

        Offer(Item item, int amount) {
            this(item, amount, amount);
        }

        Offer(Item item) {
            this(item, 1);
        }
    }

    private static class TrackKitTrade
    implements VillagerTrades.ItemListing {
        private static final List<ItemStack> TRACK_KITS = RailcraftItems.entries().stream().map(DeferredHolder::get).map(ItemStack::new).filter(kit -> kit.is(RailcraftTags.Items.TRACK_KIT)).collect(Collectors.toList());

        private TrackKitTrade() {
        }

        @Nullable
        public MerchantOffer getOffer(Entity trader, RandomSource random) {
            if (TRACK_KITS.isEmpty()) {
                return null;
            }
            ItemStack stack = TRACK_KITS.get(random.nextInt(TRACK_KITS.size()));
            if (stack.isEmpty()) {
                return null;
            }
            int size = random.nextIntBetweenInclusive(2, 6);
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, size), stack, 12, 15, 7.0f);
        }
    }

    private static class CartTrade
    implements VillagerTrades.ItemListing {
        private static final List<EntityType<? extends AbstractMinecart>> CHEAP = new ArrayList<EntityType<? extends AbstractMinecart>>();
        private static final List<EntityType<? extends AbstractMinecart>> EXPENSIVE = new ArrayList<EntityType<? extends AbstractMinecart>>();
        private final List<EntityType<? extends AbstractMinecart>> current;
        private final int priceLow;
        private final int priceHigh;

        CartTrade(boolean expensive, int priceLow, int priceHigh) {
            this.current = expensive ? EXPENSIVE : CHEAP;
            this.priceHigh = priceHigh;
            this.priceLow = priceLow;
        }

        @Nullable
        public MerchantOffer getOffer(Entity trader, RandomSource random) {
            if (this.current.isEmpty()) {
                return null;
            }
            ItemStack stack = ((AbstractMinecart)this.current.get(random.nextInt(this.current.size())).create(trader.level())).getPickResult();
            int size = random.nextIntBetweenInclusive(this.priceLow, this.priceHigh);
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, size), stack, 12, 15, 7.0f);
        }

        static {
            CHEAP.add((EntityType<? extends AbstractMinecart>)EntityType.MINECART);
            CHEAP.add((EntityType<? extends AbstractMinecart>)EntityType.CHEST_MINECART);
            CHEAP.add((EntityType<? extends AbstractMinecart>)EntityType.HOPPER_MINECART);
            CHEAP.add((EntityType<? extends AbstractMinecart>)EntityType.TNT_MINECART);
            CHEAP.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.CARGO_MINECART.get()));
            CHEAP.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TANK_MINECART.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.ELECTRIC_LOCOMOTIVE.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.WORLD_SPIKE.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.VOID_CHEST_MINECART.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TRACK_LAYER.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TRACK_RELAYER.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TRACK_REMOVER.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TRACK_UNDERCUTTER.get()));
            EXPENSIVE.add((EntityType<? extends AbstractMinecart>)((EntityType)RailcraftEntityTypes.TUNNEL_BORE.get()));
        }
    }
}

