/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class FilteredMinecart
extends RailcraftMinecart {
    private static final EntityDataAccessor<ItemStack> FILTER = SynchedEntityData.defineId(FilteredMinecart.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final AdvancedContainer filterContainer = new AdvancedContainer(1).listener((Container)this).phantom();

    protected FilteredMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected FilteredMinecart(ItemStack itemStack, EntityType<?> type, double x, double y, double z, Level level) {
        super(itemStack, type, x, y, z, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FILTER, (Object)ItemStack.EMPTY);
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.filterContainer.fromTag(tag.getList("filter", 10), (HolderLookup.Provider)this.registryAccess());
        this.entityData.set(FILTER, (Object)this.getFilterInv().getItem(0));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("filter", (Tag)this.filterContainer.createTag((HolderLookup.Provider)this.registryAccess()));
    }

    public boolean hasFilter() {
        return !this.getFilterItem().isEmpty();
    }

    public ItemStack getFilterItem() {
        return (ItemStack)this.entityData.get(FILTER);
    }

    public AdvancedContainer getFilterInv() {
        return this.filterContainer;
    }

    public void setFilter(ItemStack filter) {
        this.getFilterInv().setItem(0, filter);
    }

    public void setChanged() {
        super.setChanged();
        this.entityData.set(FILTER, (Object)this.getFilterInv().getItem(0));
    }
}

