/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ForwardingContainer;
import mods.railcraft.util.container.ItemHandlerFactory;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerBlockEntity
extends RailcraftBlockEntity
implements ForwardingContainer,
ContainerManipulator<ModifiableSlotAccessor> {
    private AdvancedContainer container;
    private IItemHandler itemHandler = new InvWrapper((Container)this);
    private Map<Direction, IItemHandlerModifiable> directionalItemHandlers = new EnumMap<Direction, IItemHandlerModifiable>(Direction.class);

    public ContainerBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        this(type, blockPos, blockState, 0);
    }

    protected ContainerBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int size) {
        super(type, blockPos, blockState);
        this.container = new AdvancedContainer(size).listener(this);
    }

    protected void setContainerSize(int size) {
        this.container = new AdvancedContainer(size).listener(this);
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.container.stream();
    }

    @Override
    public boolean stillValid(Player player) {
        return this.isStillValid(player);
    }

    @Override
    public Container container() {
        return this.container;
    }

    public IItemHandler getItemCap(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return (IItemHandler)this.directionalItemHandlers.computeIfAbsent(side, __ -> ItemHandlerFactory.wrap(this, side));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.container.fromTag(tag.getList("container", 10), provider);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("container", (Tag)this.container.createTag(provider));
    }
}

