/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import it.unimi.dsi.fastutil.chars.CharList;
import java.util.List;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.world.damagesource.RailcraftDamageSources;
import mods.railcraft.world.inventory.CrusherMenu;
import mods.railcraft.world.level.block.CrusherMultiblockBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.multiblock.BlockPredicate;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.module.CrusherModule;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CrusherBlockEntity
extends MultiblockBlockEntity<CrusherBlockEntity, Void> {
    private static final MultiblockPattern<Void> pattern = (MultiblockPattern)Util.make(() -> {
        BlockPredicate bricks = BlockPredicate.of(RailcraftBlocks.CRUSHER);
        return MultiblockPattern.builder((Vec3i)BlockPos.ZERO).layer(List.of(CharList.of((char)'0', (char)'1', (char)'2'), CharList.of((char)'5', (char)'4', (char)'3'))).layer(List.of(CharList.of((char)'A', (char)'O', (char)'A'), CharList.of((char)'A', (char)'O', (char)'A'))).predicate('A', bricks).predicate('O', bricks).predicate('0', bricks).predicate('1', bricks).predicate('2', bricks).predicate('3', bricks).predicate('4', bricks).predicate('5', bricks).build();
    });
    private static final MultiblockPattern<Void> rotatedPattern = pattern.rotateClockwise();
    private static final int KILLING_POWER_COST = 5000;
    private final CrusherModule crusherModule = this.moduleDispatcher.registerModule("crusher", new CrusherModule(this, Charge.distribution));
    private int tick = 0;

    public CrusherBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.CRUSHER.get(), blockPos, blockState, CrusherBlockEntity.class, List.of(pattern, rotatedPattern));
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, CrusherBlockEntity blockEntity) {
        blockEntity.serverTick();
        blockEntity.moduleDispatcher.serverTick();
        if (++blockEntity.tick % 8 == 0) {
            blockEntity.tick = 0;
            blockEntity.getMasterBlockEntity().ifPresent(master -> {
                BlockPos target = blockPos.above();
                IEnergyStorage energyCap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, master.getBlockPos(), null);
                EntitySearcher.findLiving().at(target).and(ModEntitySelector.KILLABLE).list(level).forEach(livingEntity -> {
                    if (energyCap != null && energyCap.getEnergyStored() >= 5000) {
                        livingEntity.hurt((DamageSource)RailcraftDamageSources.crusher(level.registryAccess()), 5.0f);
                        energyCap.extractEnergy(5000, false);
                    }
                });
            });
        }
    }

    public CrusherModule getCrusherModule() {
        return this.crusherModule;
    }

    @Override
    protected boolean isBlockEntity(MultiblockPattern.Element element) {
        return true;
    }

    @Override
    protected void membershipChanged(@Nullable MultiblockBlockEntity.Membership<CrusherBlockEntity> membership) {
        if (membership == null) {
            this.crusherModule.storage().ifPresent(storage -> storage.setState(ChargeStorage.State.DISABLED));
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)((BlockState)this.getBlockState().setValue(CrusherMultiblockBlock.TYPE, (Comparable)((Object)CrusherMultiblockBlock.Type.NONE))).setValue(CrusherMultiblockBlock.ROTATED, (Comparable)Boolean.valueOf(false))).setValue(CrusherMultiblockBlock.OUTPUT, (Comparable)Boolean.valueOf(false)));
            Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this.crusherModule);
            return;
        }
        if (membership.master() == this) {
            this.crusherModule.storage().ifPresent(storage -> storage.setState(ChargeStorage.State.RECHARGEABLE));
        }
        CrusherMultiblockBlock.Type type = switch (membership.patternElement().marker()) {
            case '0' -> CrusherMultiblockBlock.Type.NORTH_WEST;
            case '1' -> CrusherMultiblockBlock.Type.NORTH;
            case '2' -> CrusherMultiblockBlock.Type.NORTH_EAST;
            case '3' -> CrusherMultiblockBlock.Type.SOUTH_EAST;
            case '4' -> CrusherMultiblockBlock.Type.SOUTH;
            case '5' -> CrusherMultiblockBlock.Type.SOUTH_WEST;
            default -> CrusherMultiblockBlock.Type.NONE;
        };
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)((BlockState)this.getBlockState().setValue(CrusherMultiblockBlock.TYPE, (Comparable)((Object)type))).setValue(CrusherMultiblockBlock.OUTPUT, (Comparable)Boolean.valueOf(membership.patternElement().marker() == 'O'))).setValue(CrusherMultiblockBlock.ROTATED, (Comparable)Boolean.valueOf(membership.master().getCurrentPattern().get() == rotatedPattern)));
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new CrusherMenu(id, inventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)Translations.Container.CRUSHER);
    }

    @Nullable
    public IItemHandler getItemCap(@Nullable Direction side) {
        Optional<CrusherModule> masterModule = this.getMasterBlockEntity().map(CrusherBlockEntity::getCrusherModule);
        return masterModule.map(CrusherModule::getItemHandler).orElse(null);
    }

    @Nullable
    public IEnergyStorage getEnergyCap(@Nullable Direction side) {
        Optional<CrusherModule> masterModule = this.getMasterBlockEntity().map(CrusherBlockEntity::getCrusherModule);
        return masterModule.map(CrusherModule::getEnergyHandler).orElse(null);
    }
}

