/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.UUID;
import mods.railcraft.api.core.BlockEntityLike;
import mods.railcraft.api.core.NetworkSerializable;
import mods.railcraft.api.core.Ownable;
import mods.railcraft.world.module.BlockModuleProvider;
import mods.railcraft.world.module.Module;
import mods.railcraft.world.module.ModuleDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class RailcraftBlockEntity
extends BlockEntity
implements NetworkSerializable,
Ownable,
BlockEntityLike,
BlockModuleProvider {
    protected final ModuleDispatcher moduleDispatcher = new ModuleDispatcher();
    @Nullable
    private GameProfile owner;
    @Nullable
    private Component customName;

    public RailcraftBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public final CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        RegistryFriendlyByteBuf packetBuffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), this.level.registryAccess());
        this.writeToBuf(packetBuffer);
        byte[] syncData = new byte[packetBuffer.readableBytes()];
        packetBuffer.readBytes(syncData);
        tag.putByteArray("sync", syncData);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        byte[] bytes = tag.getByteArray("sync");
        this.readFromBuf(new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes)), this.level.registryAccess()));
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        this.handleUpdateTag(packet.getTag(), provider);
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        out.writeNullable((Object)this.owner, (friendlyByteBuf, gameProfile) -> {
            friendlyByteBuf.writeUUID(gameProfile.getId());
            friendlyByteBuf.writeUtf(gameProfile.getName());
        });
        out.writeNullable((Object)this.customName, (friendlyByteBuf, component) -> ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)friendlyByteBuf), component));
        this.moduleDispatcher.writeToBuf(out);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        this.owner = (GameProfile)in.readNullable(friendlyByteBuf -> {
            UUID id = friendlyByteBuf.readUUID();
            String name = friendlyByteBuf.readUtf();
            return new GameProfile(id, name);
        });
        this.customName = (Component)in.readNullable(friendlyByteBuf -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)friendlyByteBuf)));
        this.moduleDispatcher.readFromBuf(in);
    }

    @Override
    public BlockPos blockPos() {
        return this.getBlockPos();
    }

    @Override
    public Level level() {
        return this.getLevel();
    }

    @Override
    public void syncToClient() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockEntityDataPacket packet = this.getUpdatePacket();
            serverLevel.players().forEach(player -> player.connection.send((Packet)packet));
        }
    }

    @Override
    public void save() {
        this.setChanged();
    }

    @Override
    public <T extends Module> Optional<T> getModule(Class<T> type) {
        return this.moduleDispatcher.getModule(type);
    }

    @Override
    public boolean isStillValid(Player player) {
        return RailcraftBlockEntity.isStillValid(this, player, 64);
    }

    @Override
    public final void setOwner(@Nullable GameProfile profile) {
        this.owner = profile;
    }

    @Override
    public final Optional<GameProfile> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public final boolean isOwner(GameProfile gameProfile) {
        return gameProfile.equals((Object)this.owner);
    }

    public final boolean isOwnerOrOperator(GameProfile gameProfile) {
        ServerLevel serverLevel;
        Level level;
        return this.isOwner(gameProfile) || (level = this.level) instanceof ServerLevel && (serverLevel = (ServerLevel)level).getServer().getPlayerList().isOp(gameProfile);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.owner != null) {
            tag.put("owner", (Tag)ExtraCodecs.GAME_PROFILE.encode((Object)this.owner, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
        }
        if (this.customName != null) {
            tag.putString("customName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        tag.put("modules", (Tag)this.moduleDispatcher.serializeNBT(provider));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("owner", 10)) {
            this.owner = (GameProfile)ExtraCodecs.GAME_PROFILE.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("owner")).getOrThrow();
        }
        if (tag.contains("customName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("customName"), (HolderLookup.Provider)provider);
        }
        this.moduleDispatcher.deserializeNBT(provider, tag.getCompound("modules"));
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    protected void setCustomName(@Nullable Component name) {
        this.customName = name;
        this.syncToClient();
    }

    public Component getName() {
        return this.hasCustomName() ? this.customName : this.getBlockState().getBlock().getName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public final BlockEntity asBlockEntity() {
        return this;
    }

    public static boolean isStillValid(BlockEntity blockEntity, Player player, int maxDistance) {
        BlockPos pos = blockEntity.getBlockPos();
        double distance = player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return !blockEntity.isRemoved() && blockEntity.getLevel().getBlockEntity(pos).equals(blockEntity) && distance <= (double)maxDistance;
    }
}

