/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.particle.FireSparkParticleOptions;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RitualBlockEntity
extends RailcraftBlockEntity {
    public static final int[] REBUILD_DELAY = (int[])Util.make((Object)new int[8], delay -> {
        delay[0] = 128;
        delay[1] = 256;
        delay[2] = 512;
        delay[3] = 1024;
        delay[4] = 2048;
        delay[5] = 4096;
        delay[6] = 8192;
        delay[7] = 16384;
    });
    private final Deque<BlockPos> queue = new ArrayDeque<BlockPos>();
    private final Deque<BlockPos> lavaFound = new ArrayDeque<BlockPos>();
    private final Set<BlockPos> visitedBlocks = new HashSet<BlockPos>();
    private int charge;
    private int rebuildDelay;
    @Nullable
    private Component itemName;
    private int tick = 0;
    private long rotationYaw;
    private long preRotationYaw;
    private float yOffset = -2.0f;
    private float preYOffset = -2.0f;

    public RitualBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.RITUAL.get(), blockPos, blockState);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, RitualBlockEntity blockEntity) {
        blockEntity.preRotationYaw = blockEntity.rotationYaw;
        blockEntity.rotationYaw += 5L;
        if (blockEntity.rotationYaw >= 360L) {
            blockEntity.preRotationYaw = blockEntity.rotationYaw = 0L;
        }
        blockEntity.preYOffset = blockEntity.yOffset;
        if (blockEntity.yOffset < 0.0f) {
            blockEntity.yOffset += 0.0625f;
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, RitualBlockEntity blockEntity) {
        BlockPos pos;
        if (blockEntity.charge >= 5000) {
            blockEntity.tick = 0;
            return;
        }
        if (blockEntity.tick % REBUILD_DELAY[blockEntity.rebuildDelay] == 0) {
            ++blockEntity.rebuildDelay;
            if (blockEntity.rebuildDelay >= REBUILD_DELAY.length) {
                blockEntity.rebuildDelay = REBUILD_DELAY.length - 1;
            }
            blockEntity.rebuildQueue();
        }
        if ((pos = blockEntity.getNextLavaBlock(true)) != null && blockEntity.coolLava((ServerLevel)level, pos)) {
            ++blockEntity.charge;
            blockEntity.rebuildDelay = 0;
        }
        ++blockEntity.tick;
    }

    private boolean coolLava(ServerLevel level, BlockPos lavaPos) {
        boolean placed;
        FluidState fluid = level.getBlockState(lavaPos).getFluidState();
        if (fluid.is((Fluid)Fluids.LAVA) && (placed = level.setBlockAndUpdate(lavaPos, Blocks.OBSIDIAN.defaultBlockState()))) {
            Vec3 startPosition = Vec3.atLowerCornerWithOffset((Vec3i)lavaPos, (double)0.5, (double)0.5, (double)0.5);
            Vec3 endPosition = Vec3.atLowerCornerWithOffset((Vec3i)this.getBlockPos(), (double)0.5, (double)0.8, (double)0.5);
            this.fireSparkEffect(level, startPosition, endPosition);
            this.queueAdjacent(lavaPos);
            this.expandQueue();
            return true;
        }
        return false;
    }

    private void fireSparkEffect(ServerLevel level, Vec3 start, Vec3 end) {
        level.sendParticles((ParticleOptions)new FireSparkParticleOptions(end), start.x, start.y, start.z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nullable
    private BlockPos getNextLavaBlock(boolean remove) {
        if (this.queue.isEmpty()) {
            return null;
        }
        if (remove) {
            return this.queue.pollFirst();
        }
        return this.queue.peekFirst();
    }

    void rebuildQueue() {
        this.queue.clear();
        this.visitedBlocks.clear();
        this.lavaFound.clear();
        this.queueAdjacent(this.getBlockPos());
        this.expandQueue();
    }

    private void expandQueue() {
        BlockPos next;
        while ((next = this.lavaFound.poll()) != null) {
            this.queueAdjacent(next);
        }
    }

    public void queueAdjacent(BlockPos pos) {
        Direction.Plane.HORIZONTAL.forEach(side -> this.queueForFilling(pos.relative(side)));
        this.queueForFilling(pos.above());
        this.queueForFilling(pos.below());
    }

    public void queueForFilling(BlockPos index) {
        if (this.visitedBlocks.add(index)) {
            if ((index.getX() - this.worldPosition.getX()) * (index.getX() - this.worldPosition.getX()) + (index.getZ() - this.worldPosition.getZ()) * (index.getZ() - this.worldPosition.getZ()) > 4096) {
                return;
            }
            BlockState state = this.level.getBlockState(index);
            if (state.is(Blocks.OBSIDIAN) || FluidTools.getFluid(state).isSame((Fluid)Fluids.LAVA)) {
                this.lavaFound.add(index);
                if (FluidTools.isFullFluidBlock(state, this.level, index)) {
                    this.queue.addLast(index);
                }
            }
        }
    }

    public void setItemName(Component itemName) {
        this.itemName = itemName;
    }

    public int charge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public float getRotationYaw(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.preRotationYaw, (float)this.rotationYaw);
    }

    public float getYOffset(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.preYOffset, (float)this.yOffset);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putShort("charge", (short)this.charge);
        tag.putByte("rebuildDelay", (byte)this.rebuildDelay);
        if (this.itemName != null) {
            tag.putString("itemName", Component.Serializer.toJson((Component)this.itemName, (HolderLookup.Provider)provider));
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.charge = tag.getShort("charge");
        this.rebuildDelay = tag.getByte("rebuildDelay");
        if (tag.contains("itemName", 8)) {
            this.itemName = Component.Serializer.fromJson((String)tag.getString("itemName"), (HolderLookup.Provider)provider);
        }
    }
}

