/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import it.unimi.dsi.fastutil.chars.CharList;
import java.util.List;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.world.inventory.SteamOvenMenu;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.SteamOvenBlock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.multiblock.BlockPredicate;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.module.SteamOvenModule;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SteamOvenBlockEntity
extends MultiblockBlockEntity<SteamOvenBlockEntity, Void> {
    private static final MultiblockPattern<Void> pattern = (MultiblockPattern)Util.make(() -> {
        BlockPredicate bricks = BlockPredicate.of(RailcraftBlocks.STEAM_OVEN);
        return MultiblockPattern.builder((Vec3i)BlockPos.ZERO).layer(List.of(CharList.of((char)'A', (char)'B'), CharList.of((char)'C', (char)'D'))).layer(List.of(CharList.of((char)'E', (char)'F'), CharList.of((char)'G', (char)'H'))).predicate('A', bricks).predicate('B', bricks).predicate('C', bricks).predicate('D', bricks).predicate('E', bricks).predicate('F', bricks).predicate('G', bricks).predicate('H', bricks).build();
    });
    private final SteamOvenModule steamOvenModule;

    public SteamOvenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.STEAM_OVEN.get(), blockPos, blockState, SteamOvenBlockEntity.class, List.of(pattern));
        this.steamOvenModule = this.moduleDispatcher.registerModule("steam_oven", new SteamOvenModule(this));
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SteamOvenBlockEntity blockEntity) {
        blockEntity.serverTick();
        blockEntity.moduleDispatcher.serverTick();
    }

    public SteamOvenModule getSteamOvenModule() {
        return this.steamOvenModule;
    }

    @Override
    protected boolean isBlockEntity(MultiblockPattern.Element element) {
        return true;
    }

    @Override
    protected void membershipChanged(@Nullable MultiblockBlockEntity.Membership<SteamOvenBlockEntity> membership) {
        if (membership == null) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(SteamOvenBlock.TYPE, (Comparable)((Object)SteamOvenBlock.Type.DEFAULT)));
            Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this.steamOvenModule);
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)SteamOvenBlock.FACING);
        SteamOvenBlock.Type type = switch (facing) {
            case Direction.SOUTH -> {
                switch (membership.patternElement().marker()) {
                    case 'A': 
                    case 'C': {
                        yield SteamOvenBlock.Type.DOOR_TOP_LEFT;
                    }
                    case 'B': 
                    case 'D': {
                        yield SteamOvenBlock.Type.DOOR_TOP_RIGHT;
                    }
                    case 'E': 
                    case 'G': {
                        yield SteamOvenBlock.Type.DOOR_BOTTOM_LEFT;
                    }
                    case 'F': 
                    case 'H': {
                        yield SteamOvenBlock.Type.DOOR_BOTTOM_RIGHT;
                    }
                }
                yield SteamOvenBlock.Type.DEFAULT;
            }
            case Direction.NORTH -> {
                switch (membership.patternElement().marker()) {
                    case 'A': 
                    case 'C': {
                        yield SteamOvenBlock.Type.DOOR_TOP_RIGHT;
                    }
                    case 'B': 
                    case 'D': {
                        yield SteamOvenBlock.Type.DOOR_TOP_LEFT;
                    }
                    case 'E': 
                    case 'G': {
                        yield SteamOvenBlock.Type.DOOR_BOTTOM_RIGHT;
                    }
                    case 'F': 
                    case 'H': {
                        yield SteamOvenBlock.Type.DOOR_BOTTOM_LEFT;
                    }
                }
                yield SteamOvenBlock.Type.DEFAULT;
            }
            case Direction.EAST -> {
                switch (membership.patternElement().marker()) {
                    case 'A': 
                    case 'B': {
                        yield SteamOvenBlock.Type.DOOR_TOP_RIGHT;
                    }
                    case 'C': 
                    case 'D': {
                        yield SteamOvenBlock.Type.DOOR_TOP_LEFT;
                    }
                    case 'E': 
                    case 'F': {
                        yield SteamOvenBlock.Type.DOOR_BOTTOM_RIGHT;
                    }
                    case 'G': 
                    case 'H': {
                        yield SteamOvenBlock.Type.DOOR_BOTTOM_LEFT;
                    }
                }
                yield SteamOvenBlock.Type.DEFAULT;
            }
            case Direction.WEST -> {
                switch (membership.patternElement().marker()) {
                    case 'A': 
                    case 'B': {
                        yield SteamOvenBlock.Type.DOOR_TOP_LEFT;
                    }
                    case 'C': 
                    case 'D': {
                        yield SteamOvenBlock.Type.DOOR_TOP_RIGHT;
                    }
                    case 'E': 
                    case 'F': {
                        yield SteamOvenBlock.Type.DOOR_BOTTOM_LEFT;
                    }
                    case 'G': 
                    case 'H': {
                        yield SteamOvenBlock.Type.DOOR_BOTTOM_RIGHT;
                    }
                }
                yield SteamOvenBlock.Type.DEFAULT;
            }
            default -> SteamOvenBlock.Type.DEFAULT;
        };
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(SteamOvenBlock.TYPE, (Comparable)((Object)type)));
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new SteamOvenMenu(id, inventory, this);
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)Translations.Container.STEAM_OVEN);
    }

    @Nullable
    public IItemHandler getItemCap(@Nullable Direction side) {
        Optional<SteamOvenModule> masterModule = this.getMasterBlockEntity().map(SteamOvenBlockEntity::getSteamOvenModule);
        return masterModule.map(SteamOvenModule::getItemHandler).orElse(null);
    }

    @Nullable
    public IFluidHandler getFluidCap(@Nullable Direction side) {
        Optional<SteamOvenModule> masterModule = this.getMasterBlockEntity().map(SteamOvenBlockEntity::getSteamOvenModule);
        return masterModule.map(SteamOvenModule::getSteamTank).orElse(null);
    }
}

