/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LauncherTrackBlockEntity
extends RailcraftBlockEntity {
    public static final int MIN_LAUNCH_FORCE = 5;
    private static final float LAUNCH_THRESHOLD = 0.01f;
    private byte launchForce = (byte)5;

    public LauncherTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.LAUNCHER_TRACK.get(), blockPos, blockState);
    }

    public void minecartPassed(AbstractMinecart cart) {
        if (PoweredOutfittedTrackBlock.isPowered(this.getBlockState())) {
            Vec3 motion = cart.getDeltaMovement();
            double newMotionX = motion.x();
            double newMotionZ = motion.z();
            if (Math.abs(motion.x()) > (double)0.01f) {
                newMotionX = Math.copySign((double)0.6f, motion.x());
            }
            if (Math.abs(motion.z()) > (double)0.01f) {
                newMotionZ = Math.copySign((double)0.6f, motion.z());
            }
            cart.setMaxSpeedAirLateral(0.6f);
            cart.setMaxSpeedAirVertical(0.5f);
            cart.setDragAir(0.99999);
            RollingStock.getOrThrow(cart).launch();
            cart.setDeltaMovement(newMotionX, (double)this.getLaunchForce() * 0.1, newMotionZ);
            cart.move(MoverType.SELF, cart.getDeltaMovement());
        }
    }

    public byte getLaunchForce() {
        return this.launchForce;
    }

    public void setLaunchForce(byte launchForce) {
        this.launchForce = (byte)Mth.clamp((int)launchForce, (int)5, (int)((Integer)RailcraftConfig.SERVER.maxLauncherTrackForce.get()));
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putByte("launchForce", this.launchForce);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.launchForce = tag.getByte("launchForce");
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeByte(this.launchForce);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.launchForce = in.readByte();
    }
}

