/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.outfitted.OutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class DetectorTrackBlock
extends OutfittedTrackBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Mode> MODE = EnumProperty.create((String)"mode", Mode.class);

    public DetectorTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)((BlockState)super.buildDefaultState(blockState).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(MODE, (Comparable)((Object)Mode.BI_DIRECTIONAL));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED, MODE});
    }

    @Override
    public void tick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        ((Mode)((Object)blockState.getValue(MODE))).updatePowerState(blockState, (Level)level, blockPos);
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos blockPos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, blockPos, cart);
        ((Mode)((Object)blockState.getValue(MODE))).updatePowerState(blockState, level, blockPos);
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack) {
        Mode mode = (Mode)((Object)blockState.getValue(MODE));
        Mode newMode = player.isCrouching() ? mode.previous() : mode.next();
        return level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(MODE, (Comparable)((Object)newMode)));
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos blockPos, Direction direction) {
        return this.getSignal(state, level, blockPos, direction);
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)POWERED);
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        if (this.hasAnalogOutputSignal(blockState)) {
            List<AbstractMinecart> carts = EntitySearcher.findMinecarts().at(pos).upTo(-0.2f).list(level);
            if (!carts.isEmpty() && carts.getFirst().getComparatorLevel() > -1) {
                return carts.getFirst().getComparatorLevel();
            }
            List<MinecartCommandBlock> commandCarts = EntitySearcher.find(MinecartCommandBlock.class).at(pos).upTo(-0.2f).list(level);
            if (!commandCarts.isEmpty()) {
                return commandCarts.getFirst().getCommandBlock().getSuccessCount();
            }
            List<AbstractMinecart> chestCarts = EntitySearcher.findMinecarts().at(pos).upTo(-0.2f).and(EntitySelector.CONTAINER_ENTITY_SELECTOR).list(level);
            if (!chestCarts.isEmpty()) {
                return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Container)chestCarts.getFirst()));
            }
        }
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.translatable((String)Translations.Tips.DETECTOR_TRACK).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.translatable((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_DETECTION_DIRECTION).withStyle(ChatFormatting.BLUE));
        lines.add((Component)Component.translatable((String)Translations.Tips.COMPARATOR_OUTPUT_FROM_CARTS).withStyle(ChatFormatting.RED));
    }

    public static enum Mode implements StringRepresentable
    {
        BI_DIRECTIONAL("bi_directional"){

            @Override
            protected void updatePowerState(BlockState blockState, Level level, BlockPos blockPos) {
                Mode.setTrackPowering(blockState, level, blockPos, !Mode.findCarts(level, blockPos).isEmpty());
            }
        }
        ,
        TRAVEL("travel"){

            @Override
            protected void updatePowerState(BlockState blockState, Level level, BlockPos blockPos) {
                2.updatePowerState(blockState, level, blockPos, false);
            }
        }
        ,
        TRAVEL_REVERSED("travel_reversed"){

            @Override
            protected void updatePowerState(BlockState blockState, Level level, BlockPos blockPos) {
                3.updatePowerState(blockState, level, blockPos, true);
            }
        };

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        protected static void updatePowerState(BlockState blockState, Level level, BlockPos blockPos, boolean reversed) {
            List<AbstractMinecart> carts = Mode.findCarts(level, blockPos);
            if (carts.isEmpty()) {
                Mode.setTrackPowering(blockState, level, blockPos, false);
                return;
            }
            RailShape shape = TrackBlock.getRailShapeRaw(blockState);
            Predicate<AbstractMinecart> travelling = RailShapeUtil.isEastWest(shape) ? cart -> reversed ? cart.getDeltaMovement().x() < 0.0 : cart.getDeltaMovement().x() > 0.0 : cart -> reversed ? cart.getDeltaMovement().z() > 0.0 : cart.getDeltaMovement().z() < 0.0;
            Mode.setTrackPowering(blockState, level, blockPos, carts.stream().anyMatch(travelling));
        }

        private static void setTrackPowering(BlockState blockState, Level level, BlockPos blockPos, boolean powered) {
            if (powered) {
                level.scheduleTick(blockPos, blockState.getBlock(), 10);
            }
            if (powered != (Boolean)blockState.getValue((Property)POWERED)) {
                level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
                level.updateNeighborsAt(blockPos, blockState.getBlock());
                level.updateNeighborsAt(blockPos.relative(Direction.DOWN), blockState.getBlock());
            }
        }

        private static List<AbstractMinecart> findCarts(Level level, BlockPos blockPos) {
            return EntitySearcher.findMinecarts().at(blockPos).upTo(-0.2f).list(level);
        }

        public String getSerializedName() {
            return this.name;
        }

        private Mode next() {
            return (Mode)EnumUtil.next((Enum)this, (Enum[])Mode.values());
        }

        private Mode previous() {
            return (Mode)EnumUtil.previous((Enum)this, (Enum[])Mode.values());
        }

        protected void updatePowerState(BlockState blockState, Level level, BlockPos blockPos) {
        }
    }
}

