/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material.steam;

import com.google.common.primitives.Floats;
import java.util.List;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.gui.widget.Gauge;
import mods.railcraft.world.level.material.FuelProvider;
import mods.railcraft.world.level.material.RailcraftFluids;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class SteamBoiler
implements INBTSerializable<CompoundTag> {
    private final Gauge temperatureGauge = new TemperatureGauge();
    private final StandardTank waterTank;
    private final StandardTank steamTank;
    private float burnTime;
    private float currentItemBurnTime;
    protected boolean burning;
    protected byte burnCycle;
    private double partialConversions;
    private float temperature = 20.0f;
    private float maxTemperature = 500.0f;
    private double efficiencyModifier = 1.0;
    private int ticksPerCycle = 16;
    @Nullable
    private Runnable changeListener;
    private FuelProvider fuelProvider;

    public SteamBoiler(StandardTank waterTank, StandardTank steamTank) {
        this.waterTank = waterTank;
        this.steamTank = steamTank;
    }

    public IFluidTank getWaterTank() {
        return this.waterTank;
    }

    public IFluidTank getSteamTank() {
        return this.steamTank;
    }

    public FluidStack checkFill(FluidStack resource, Runnable explosionCallback) {
        FluidStack water;
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.isSuperHeated() && (water = this.waterTank.getFluid()).isEmpty()) {
            explosionCallback.run();
            return FluidStack.EMPTY;
        }
        return resource;
    }

    public SteamBoiler setFuelProvider(FuelProvider fuelProvider) {
        this.fuelProvider = fuelProvider;
        return this;
    }

    public SteamBoiler setChangeListener(@Nullable Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public SteamBoiler setTicksPerCycle(int ticks) {
        this.ticksPerCycle = ticks;
        return this;
    }

    public SteamBoiler setEfficiencyModifier(double modifier) {
        this.efficiencyModifier = modifier;
        return this;
    }

    public float getMaxTemperature() {
        return this.maxTemperature;
    }

    public SteamBoiler setMaxTemperature(float maxTemperature) {
        this.maxTemperature = maxTemperature;
        this.temperatureGauge.refresh();
        return this;
    }

    public float getHeatStep() {
        return this.fuelProvider == null ? 0.05f : this.fuelProvider.getHeatStep();
    }

    public void reset() {
        this.setTemperature(20.0f);
    }

    public float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(float temperature) {
        this.temperature = Floats.constrainToRange((float)temperature, (float)20.0f, (float)this.getMaxTemperature());
    }

    public float getTemperaturePercent() {
        return this.temperature / this.getMaxTemperature();
    }

    public void increaseHeat(int numTanks) {
        float max = this.getMaxTemperature();
        if (this.temperature == max) {
            return;
        }
        float step = this.getHeatStep();
        float delta = step + (max - this.temperature) / max * step * 3.0f;
        this.setTemperature(this.getTemperature() + (delta /= (float)numTanks));
    }

    public void reduceHeat(int numTanks) {
        if (this.temperature == 20.0f) {
            return;
        }
        float step = 0.05f;
        float delta = step + this.temperature / this.getMaxTemperature() * step * 3.0f;
        this.setTemperature(this.getTemperature() - (delta /= (float)numTanks));
    }

    public boolean isCold() {
        return this.getTemperature() < 100.0f;
    }

    public boolean isSuperHeated() {
        return this.getTemperature() >= 300.0f;
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burning) {
        this.burning = burning;
    }

    public boolean hasFuel() {
        return this.getBurnTime() > 0.0f;
    }

    public int getBurnProgressScaled(int i) {
        if (this.isCold()) {
            return 0;
        }
        int scale = (int)(this.getBurnTime() / this.getCurrentItemBurnTime() * (float)i);
        return Math.clamp((long)scale, 0, i);
    }

    private boolean addFuel() {
        if (this.fuelProvider == null) {
            return false;
        }
        float fuel = this.fuelProvider.consumeFuel();
        if (fuel <= 0.0f) {
            return false;
        }
        this.setBurnTime(this.getBurnTime() + fuel);
        this.setCurrentItemBurnTime(this.getBurnTime());
        return true;
    }

    public float getFuelPerCycle(int numTanks) {
        float fuel = 8.0f;
        fuel -= (float)numTanks * 8.0f * 0.0125f;
        fuel += 0.8f * this.getTemperaturePercent();
        fuel += 4.0f * (this.getMaxTemperature() / 1000.0f);
        fuel *= (float)numTanks;
        fuel = (float)((double)fuel * this.efficiencyModifier);
        fuel = (float)((double)fuel * (Double)RailcraftConfig.SERVER.fuelPerSteamMultiplier.get());
        return fuel;
    }

    public void tick(int numTanks) {
        this.burnCycle = (byte)(this.burnCycle + 1);
        if (this.burnCycle >= this.ticksPerCycle) {
            boolean addedFuel;
            this.burnCycle = 0;
            float fuelNeeded = this.getFuelPerCycle(numTanks);
            while (this.getBurnTime() < fuelNeeded && (addedFuel = this.addFuel())) {
            }
            boolean wasBurning = this.burning;
            boolean bl = this.burning = this.getBurnTime() >= fuelNeeded;
            if (this.burning) {
                this.setBurnTime(this.getBurnTime() - fuelNeeded);
            } else {
                this.setBurnTime(0.0f);
            }
            if (this.changeListener != null && this.burning != wasBurning) {
                this.changeListener.run();
            }
            this.convertSteam(numTanks);
        }
        if (this.burning) {
            this.increaseHeat(numTanks);
        } else {
            this.reduceHeat(numTanks);
        }
    }

    public int convertSteam(int numTanks) {
        if (this.isCold()) {
            return 0;
        }
        this.partialConversions += (double)((float)numTanks * this.getTemperaturePercent());
        int waterCost = (int)this.partialConversions;
        if (waterCost <= 0) {
            return 0;
        }
        this.partialConversions -= (double)waterCost;
        FluidStack water = this.waterTank.internalDrain(waterCost, IFluidHandler.FluidAction.SIMULATE);
        if (water.isEmpty()) {
            return 0;
        }
        waterCost = Math.min(waterCost, water.getAmount());
        FluidStack steam = new FluidStack((Fluid)RailcraftFluids.STEAM.get(), 160 * waterCost);
        this.waterTank.internalDrain(waterCost, IFluidHandler.FluidAction.EXECUTE);
        this.steamTank.internalFill(steam, IFluidHandler.FluidAction.EXECUTE);
        return steam.getAmount();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putFloat("temperature", this.temperature);
        tag.putFloat("maxTemperature", this.maxTemperature);
        tag.putFloat("burnTime", this.burnTime);
        tag.putFloat("currentItemBurnTime", this.currentItemBurnTime);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.setTemperature(tag.getFloat("temperature"));
        this.setMaxTemperature(tag.getFloat("maxTemperature"));
        this.setBurnTime(tag.getFloat("burnTime"));
        this.setCurrentItemBurnTime(tag.getFloat("currentItemBurnTime"));
    }

    public Gauge getTemperatureGauge() {
        return this.temperatureGauge;
    }

    public float getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public float setCurrentItemBurnTime(float currentItemBurnTime) {
        this.currentItemBurnTime = currentItemBurnTime;
        return currentItemBurnTime;
    }

    public float getBurnTime() {
        return this.burnTime;
    }

    public float setBurnTime(float burnTime) {
        this.burnTime = burnTime;
        return burnTime;
    }

    private class TemperatureGauge
    implements Gauge {
        private List<Component> tooltip;

        private TemperatureGauge() {
        }

        @Override
        public void refresh() {
            this.tooltip = List.of(Component.literal((String)String.format("%.0f\u00b0C", Float.valueOf(SteamBoiler.this.getTemperature()))));
        }

        @Override
        public List<Component> getTooltip() {
            return this.tooltip;
        }

        @Override
        public float getMeasurement() {
            return (SteamBoiler.this.getTemperature() - 20.0f) / (SteamBoiler.this.getMaxTemperature() - 20.0f);
        }

        @Override
        public float getServerValue() {
            return SteamBoiler.this.getTemperature();
        }

        @Override
        public float getClientValue() {
            return SteamBoiler.this.getTemperature();
        }

        @Override
        public void setClientValue(float value) {
            SteamBoiler.this.setTemperature(value);
        }
    }
}

