/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.network;

import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="fdlib", bus=EventBusSubscriber.Bus.MOD)
public class PacketHandler {
    @SubscribeEvent
    public static void autoRegisterPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("fdlib").versioned("1").optional();
        List<Class<?>> packets = FDHelpers.getAnnotatedClasses(RegisterFDPacket.class);
        for (Class<?> clazz : packets) {
            RegisterFDPacket annotation = clazz.getAnnotation(RegisterFDPacket.class);
            CustomPacketPayload.Type<FDPacket> type = FDPacket.typeFor(annotation);
            try {
                Constructor<?> constructor;
                try {
                    constructor = clazz.getConstructor(FriendlyByteBuf.class);
                }
                catch (Exception e) {
                    constructor = clazz.getConstructor(RegistryFriendlyByteBuf.class);
                }
                Constructor<?> finalConstructor = constructor;
                StreamCodec codec = StreamCodec.of((buf, payload) -> payload.write((RegistryFriendlyByteBuf)buf), buf -> {
                    try {
                        FDPacket o = (FDPacket)finalConstructor.newInstance(buf);
                        return o;
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
                registrar.playBidirectional(type, codec, (payload, context) -> context.enqueueWork(() -> {
                    if (EffectiveSide.get().isClient()) {
                        payload.clientAction(context);
                    } else {
                        payload.serverAction(context);
                    }
                }));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

