/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head;

import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.HeadControllerContainer;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.head.IHasHead;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdlib:head_controller_change_mode")
public class ChangeHeadControllerModePacket<T extends Mob & IHasHead<T>>
extends FDPacket {
    private HeadControllerContainer.Mode mode;
    private int entityId;

    public ChangeHeadControllerModePacket(T entity, HeadControllerContainer.Mode mode) {
        this.entityId = entity.getId();
        this.mode = mode;
    }

    public ChangeHeadControllerModePacket(RegistryFriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.mode = (HeadControllerContainer.Mode)buf.readEnum(HeadControllerContainer.Mode.class);
    }

    @Override
    public void write(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        registryFriendlyByteBuf.writeInt(this.entityId);
        registryFriendlyByteBuf.writeEnum((Enum)this.mode);
    }

    @Override
    public void clientAction(IPayloadContext iPayloadContext) {
        Entity entity = FDClientHelpers.getClientLevel().getEntity(this.entityId);
        if (entity instanceof Mob) {
            Mob mob;
            Mob e = mob = (Mob)entity;
            ((IHasHead)e).getHeadControllerContainer().setControllersMode(this.mode);
        }
    }

    @Override
    public void serverAction(IPayloadContext iPayloadContext) {
    }
}

