/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system;

import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.BoneAttachments;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.model_system.attachments.ModelAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class LayerAttachments
implements INBTSerializable<CompoundTag> {
    private HashMap<String, BoneAttachments> layerAttachments = new HashMap();

    protected void attach(String boneName, UUID uuid, ModelAttachment<?, ?> attachment) {
        BoneAttachments boneAttachments = this.getBoneAttachments(boneName);
        boneAttachments.attach(uuid, attachment);
    }

    protected boolean removeAttachment(UUID uuid) {
        for (BoneAttachments v : this.layerAttachments.values()) {
            if (!v.removeAttachment(uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttachment(UUID attachmentUUID) {
        for (BoneAttachments boneAttachment : this.layerAttachments.values()) {
            if (!boneAttachment.hasAttachment(attachmentUUID)) continue;
            return true;
        }
        return false;
    }

    public BoneAttachments getBoneAttachments(String boneName) {
        return this.layerAttachments.computeIfAbsent(boneName, v -> new BoneAttachments());
    }

    public Collection<String> getAllBones() {
        return this.layerAttachments.keySet();
    }

    public List<Pair<UUID, ModelAttachment<?, ?>>> getAllAttachments() {
        ArrayList list = new ArrayList();
        for (BoneAttachments boneAttachments : this.layerAttachments.values()) {
            list.addAll(boneAttachments.getAttachments());
        }
        return list;
    }

    public List<Pair<UUID, ModelAttachment<?, ?>>> getAllBoneAttachments(String bone) {
        return this.getBoneAttachments(bone).getAttachments();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        int id = 0;
        for (Map.Entry<String, BoneAttachments> entry : this.layerAttachments.entrySet()) {
            CompoundTag boneAttachment = new CompoundTag();
            boneAttachment.putString("bone", entry.getKey());
            CompoundTag boneAttachments = entry.getValue().serializeNBT(provider);
            boneAttachment.put("attachment", (Tag)boneAttachments);
            tag.put("attachment_" + id++, (Tag)boneAttachment);
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.layerAttachments = new HashMap();
        int id = 0;
        while (tag.contains("attachment_" + id)) {
            CompoundTag t = tag.getCompound("attachment_" + id);
            BoneAttachments boneAttachments = new BoneAttachments();
            boneAttachments.deserializeNBT(provider, t.getCompound("attachment"));
            String bone = t.getString("bone");
            this.layerAttachments.put(bone, boneAttachments);
            ++id;
        }
    }
}

