/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.bedrock.models;

import com.finderfeed.fdlib.systems.bedrock.models.FDCube;
import com.finderfeed.fdlib.systems.bedrock.models.FDFace;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelInfo;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelPart;
import com.finderfeed.fdlib.systems.bedrock.models.FDModelPartDefinition;
import com.finderfeed.fdlib.util.math.RaycastUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class FDModel {
    private ResourceLocation modelName;
    public FDModelPart main;
    private Map<String, FDModelPart> partsLookup;

    public FDModel(FDModelInfo info) {
        this.modelName = info.getModelName();
        this.load(info.partDefinitionList);
    }

    public void render(PoseStack matrices, VertexConsumer vertex, int light, int overlay, float r, float g, float b, float a) {
        this.main.render(matrices, vertex, light, overlay, r, g, b, a);
    }

    public Vector3f traceCubesInModelPart(Vector3f offset, Vector3f p1, Vector3f p2, String name) {
        FDModelPart part = this.partsLookup.get(name);
        Matrix4f transformation = this.getModelPartTransformation(part);
        ArrayList<Vector3f> vs = new ArrayList<Vector3f>();
        for (FDCube cube : part.cubes) {
            for (FDFace fdFace : cube.getFaces()) {
                Vector3f tracedPoint;
                List<Vector3f> vertices = Arrays.stream(fdFace.getVertices()).map(fdVertex -> {
                    Vector3f v = fdVertex.getPosition();
                    Vector4f t = transformation.transform(new Vector4f(v.x / 16.0f, v.y / 16.0f, v.z / 16.0f, 1.0f));
                    return new Vector3f(t.x + offset.x, t.y + offset.y, t.z + offset.z);
                }).toList();
                Matrix3f m = transformation.normal(new Matrix3f());
                Vector3f normal = m.transform((Vector3fc)fdFace.getNormal(), new Vector3f());
                if (vertices.size() != 4 || !RaycastUtil.isPointOnLine(p1, p2, tracedPoint = RaycastUtil.traceInfinitePlane(vertices.get(0), normal.mul(-1.0f, new Vector3f()), p1, p2), 0.005f) || !RaycastUtil.isPointInSquare(vertices.get(0), vertices.get(1), vertices.get(2), vertices.get(3), tracedPoint)) continue;
                vs.add(tracedPoint);
            }
        }
        if (!vs.isEmpty()) {
            vs.sort(Comparator.comparingDouble(v -> v.sub((Vector3fc)p1, new Vector3f()).length()));
            return (Vector3f)vs.get(0);
        }
        return null;
    }

    public Matrix4f getModelPartTransformation(String name) {
        FDModelPart part = this.partsLookup.get(name);
        if (part == null) {
            throw new RuntimeException("No such part exist.");
        }
        return this.getModelPartTransformation(part);
    }

    public Matrix4f getModelPartTransformation(FDModelPart part) {
        Matrix4f mat = new Matrix4f();
        if (part.parent != null) {
            this.collectParentTransformations(part, mat);
        } else {
            part.transform(mat);
        }
        return mat;
    }

    public Vector3f transformPoint(String boneName, Vector3f point) {
        Vector4f p = new Vector4f(point.x, point.y, point.z, 1.0f);
        this.getModelPartTransformation(boneName).transform(p);
        return new Vector3f(p.x, p.y, p.z);
    }

    private void collectParentTransformations(FDModelPart part, Matrix4f mat) {
        ArrayList<FDModelPart> parts = new ArrayList<FDModelPart>();
        FDModelPart p = part;
        while (p != null) {
            parts.add(p);
            p = p.parent;
        }
        for (int i = parts.size() - 1; i >= 0; --i) {
            p = (FDModelPart)parts.get(i);
            p.transform(mat);
        }
    }

    public FDModelPart getModelPart(String name) {
        FDModelPart part = this.partsLookup.get(name);
        if (part != null) {
            return part;
        }
        return null;
    }

    public FDModelPart getPartOrNull(String name) {
        return this.partsLookup.get(name);
    }

    public void resetTransformations() {
        this.main.reset();
    }

    private void load(List<FDModelPartDefinition> definitions) {
        Object parent;
        HashMap<String, FDModelPart> allParts = new HashMap<String, FDModelPart>();
        HashMap<String, Object> childParent = new HashMap<String, Object>();
        ArrayList<FDModelPart> noParentsParts = new ArrayList<FDModelPart>();
        for (FDModelPartDefinition fDModelPartDefinition : definitions) {
            List<FDCube> cubes = fDModelPartDefinition.cubes;
            String name = fDModelPartDefinition.name;
            parent = fDModelPartDefinition.parent;
            Vector3f rotation = fDModelPartDefinition.initRotation;
            Vector3f pivot = fDModelPartDefinition.pivot;
            FDModelPart part2 = new FDModelPart(name, (FDModelPart)allParts.get(parent), cubes, pivot, rotation);
            allParts.put(name, part2);
            if (!((String)parent).equals("")) {
                childParent.put(name, parent);
                continue;
            }
            noParentsParts.add(part2);
        }
        for (Map.Entry entry : childParent.entrySet()) {
            String sname = (String)entry.getKey();
            String sparent = (String)entry.getValue();
            parent = (FDModelPart)allParts.get(sparent);
            FDModelPart child = (FDModelPart)allParts.get(sname);
            ((FDModelPart)parent).children.put(child.name, child);
        }
        this.main = new FDModelPart("root", null, new ArrayList<FDCube>(), new Vector3f(), new Vector3f());
        noParentsParts.forEach(part -> {
            this.main.children.put(part.name, (FDModelPart)part);
            part.parent = this.main;
        });
        this.partsLookup = allParts;
    }

    public ResourceLocation getModelInfoId() {
        return this.modelName;
    }
}

