/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle;

import com.finderfeed.fdlib.systems.particle.CircleParticleProcessor;
import com.finderfeed.fdlib.systems.particle.CompositeParticleProcessor;
import com.finderfeed.fdlib.systems.particle.EmptyParticleProcessor;
import com.finderfeed.fdlib.systems.particle.ParticleProcessor;
import com.finderfeed.fdlib.systems.particle.ParticleProcessorType;
import com.finderfeed.fdlib.systems.particle.SetParticleSpeedProcessor;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public class FDParticleProcessors {
    private static final HashMap<String, ParticleProcessorType<?>> PARTICLE_PROCESSORS = new HashMap();
    public static final ParticleProcessorType<EmptyParticleProcessor> EMPTY_PROCESSOR = FDParticleProcessors.register(new EmptyParticleProcessor.Type());
    public static final ParticleProcessorType<CompositeParticleProcessor> COMPOSITE = FDParticleProcessors.register(new CompositeParticleProcessor.Type());
    public static final ParticleProcessorType<CircleParticleProcessor> CIRCLE_PARTICLE_PROCESSOR = FDParticleProcessors.register(new CircleParticleProcessor.Type());
    public static final ParticleProcessorType<SetParticleSpeedProcessor> SET_PARTICLE_SPEED = FDParticleProcessors.register(new SetParticleSpeedProcessor.Type());

    public static <T extends ParticleProcessor<T>> ParticleProcessorType<T> register(ParticleProcessorType<T> type) {
        PARTICLE_PROCESSORS.put(type.id().toString(), type);
        return type;
    }

    public static ParticleProcessorType<?> getType(ResourceLocation location) {
        return PARTICLE_PROCESSORS.get(location.toString());
    }
}

