/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.overlay;

import com.finderfeed.fdbosses.client.particles.arc_lightning.ArcLightningParticle;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdlib.init.FDCoreShaders;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDShaderRenderer;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="fdbosses", value={Dist.CLIENT})
public class ElectrifiedOverlay
implements LayeredDraw.Layer {
    private static int electrifiedEffectTick = 0;
    private static int electrifiedEffectTickO = 0;
    private static int electrifiedEffectTickMax = 20;

    @SubscribeEvent
    public static void detectChesedEffect(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            electrifiedEffectTick = 0;
            electrifiedEffectTickO = 0;
            return;
        }
        electrifiedEffectTickMax = 10;
        electrifiedEffectTickO = electrifiedEffectTick;
        electrifiedEffectTick = player.hasEffect(BossEffects.CHESED_ENERGIZED) ? Mth.clamp((int)(electrifiedEffectTick + 1), (int)0, (int)electrifiedEffectTickMax) : Mth.clamp((int)(electrifiedEffectTick - 1), (int)0, (int)electrifiedEffectTickMax);
    }

    public static float getElectrifiedEffectPercent(float partialTick) {
        return FDMathUtil.lerp((float)electrifiedEffectTickO, (float)electrifiedEffectTick, (float)partialTick) / (float)electrifiedEffectTickMax;
    }

    public void render(GuiGraphics graphics, DeltaTracker tracker) {
        if (electrifiedEffectTick == 0 && electrifiedEffectTickO == 0) {
            return;
        }
        Window window = Minecraft.getInstance().getWindow();
        float width = window.getGuiScaledWidth();
        float height = window.getGuiScaledHeight();
        PoseStack matrices = graphics.pose();
        matrices.pushPose();
        float alphamod = ElectrifiedOverlay.getElectrifiedEffectPercent(tracker.getGameTimeDeltaPartialTick(true));
        alphamod = FDEasings.easeOut((float)alphamod);
        this.renderElectrifiedThing(graphics, 0.0f, 0.0f, 30.0f, alphamod);
        this.renderElectrifiedThing(graphics, width, 0.0f, -30.0f, alphamod);
        this.renderElectrifiedThing(graphics, width, height, 205.0f, alphamod);
        this.renderElectrifiedThing(graphics, 0.0f, height, -205.0f, alphamod);
        matrices.popPose();
    }

    private void renderElectrifiedThing(GuiGraphics graphics, float x, float y, float angle, float alphamod) {
        Window window = Minecraft.getInstance().getWindow();
        float width = window.getGuiScaledWidth();
        float height = window.getGuiScaledHeight();
        float time = (float)(System.currentTimeMillis() % 356556456L) / 100000.0f;
        GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
        PoseStack matrices = graphics.pose();
        matrices.pushPose();
        matrices.translate(x, y, 0.0f);
        float noiseAlpha = 0.7f * alphamod;
        matrices.mulPose(Axis.ZN.rotationDegrees(angle));
        matrices.pushPose();
        matrices.translate(0.0f, 20.0f, 0.0f);
        FDShaderRenderer.start((GuiGraphics)graphics, (ShaderInstance)FDCoreShaders.NOISE).position(0.0f, 0.0f, 0.0f).setUpColor(0.5f, 1.0f, 1.0f, noiseAlpha).setDownColor(0.5f, 1.0f, 1.0f, 0.0f).setResolution(width, 40.0f).setCentered(true).setShaderUniform("size", new float[]{width, 40.0f}).setShaderUniform("xyOffset", new float[]{0.0f, -time * 3.0f}).setShaderUniform("sections", new float[]{50.0f}).setShaderUniform("octaves", new float[]{4.0f}).setShaderUniform("time", new float[]{time * 5.0f}).end();
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.0f, 40.0f, 0.0f);
        FDShaderRenderer.start((GuiGraphics)graphics, (ShaderInstance)GameRenderer.getPositionColorShader()).position(0.0f, 0.0f, 0.0f).setUpColor(0.5f, 1.0f, 1.0f, noiseAlpha).setDownColor(0.5f, 1.0f, 1.0f, 0.0f).setResolution(width, 80.0f).setCentered(true).end();
        matrices.popPose();
        float lightningAlpha = alphamod;
        matrices.pushPose();
        matrices.translate(0.0f, 30.0f, 0.0f);
        Matrix4f t = matrices.last().pose();
        List<Vec3> positions = List.of(new Vec3(-150.0, 0.0, 0.0), new Vec3(150.0, 0.0, 0.0));
        ArcLightningParticle.fullLightningImmediateDraw(System.currentTimeMillis() / 50L, 42354355, 10, t, positions, 5.0f, 10.0f, 0.3f, 1.0f, 1.0f, alphamod);
        ArcLightningParticle.fullLightningImmediateDraw(System.currentTimeMillis() / 50L, 42354355, 10, t, positions, 1.5f, 10.0f, 1.0f, 1.0f, 1.0f, alphamod);
        ArcLightningParticle.fullLightningImmediateDraw(System.currentTimeMillis() / 50L, 54354355, 10, t, positions, 1.5f, 20.0f, 1.0f, 1.0f, 1.0f, alphamod);
        matrices.popPose();
        matrices.popPose();
    }
}

