/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles;

import com.finderfeed.fdbosses.client.particles.DecalParticleOptions;
import com.finderfeed.fdlib.util.client.particles.options.AlphaOptions;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class DecalParticle
extends Particle {
    private DecalParticleOptions decalParticleOptions;
    private ComplexEasingFunction easingFunction;

    public DecalParticle(DecalParticleOptions decalParticleOptions, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.decalParticleOptions = decalParticleOptions;
        AlphaOptions alphaOptions = decalParticleOptions.getAlphaOptions();
        this.lifetime = alphaOptions.fullTime();
        this.easingFunction = ComplexEasingFunction.builder().addArea((float)alphaOptions.inTime, FDEasings::linear).addArea((float)alphaOptions.stayTime, FDEasings::one).addArea((float)alphaOptions.outTime, FDEasings::reversedLinear).build();
    }

    public void render(VertexConsumer vertex, Camera camera, float pticks) {
        Vec3 camPos = camera.getPosition();
        Vec3 thisPos = FDMathUtil.interpolateVectors((Vec3)new Vec3(this.xo, this.yo, this.zo), (Vec3)new Vec3(this.x, this.y, this.z), (float)pticks);
        Vec3 translation = thisPos.subtract(camPos);
        Matrix4f mat = new Matrix4f();
        mat.translate((float)translation.x, (float)translation.y, (float)translation.z);
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mat, (Vec3)this.decalParticleOptions.getDirection());
        float roll = FDMathUtil.lerp((float)this.oRoll, (float)this.roll, (float)pticks);
        mat.rotateY((float)Math.toRadians(roll));
        float alpha = this.easingFunction.apply((float)this.age + pticks);
        float size = this.decalParticleOptions.getSize();
        int light = this.getLightColor(pticks);
        vertex.addVertex(mat, size, 0.0f, size).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 0.0f).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
        vertex.addVertex(mat, size, 0.0f, -size).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(0.0f, 1.0f).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
        vertex.addVertex(mat, -size, 0.0f, -size).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(1.0f, 1.0f).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
        vertex.addVertex(mat, -size, 0.0f, size).setColor(1.0f, 1.0f, 1.0f, alpha).setUv(1.0f, 0.0f).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
    }

    public DecalParticleOptions getDecalParticleOptions() {
        return this.decalParticleOptions;
    }
}

