/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles;

import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;

public abstract class GravityOptionsParticle
extends TextureSheetParticle {
    private GravityParticleOptions options;
    private float particleRollO = 0.0f;
    private float particleRoll = 0.0f;
    private float particleQuadSize;

    public GravityOptionsParticle(GravityParticleOptions gravityParticleOptions, ClientLevel leve, double x, double y, double z, double xd, double yd, double zd) {
        super(leve, x, y, z, xd, yd, zd);
        this.options = gravityParticleOptions;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.particleRoll = this.roll = leve.random.nextFloat() * (float)Math.PI * 2.0f;
        this.particleRollO = this.roll;
        this.gravity = gravityParticleOptions.getGravity();
        this.quadSize = this.options.getQuadSize();
        this.particleQuadSize = gravityParticleOptions.getQuadSize();
        this.lifetime = this.options.getLifetime();
        this.hasPhysics = true;
    }

    public void tick() {
        super.tick();
        Vec3 v = new Vec3(this.xo - this.x, this.yo - this.y, this.zo - this.z);
        float length = (float)v.length();
        this.particleRollO = this.particleRoll;
        this.particleRoll += length * this.options.getRotationModifier();
    }

    public void render(VertexConsumer consumer, Camera camera, float pticks) {
        this.roll = this.particleRoll;
        this.oRoll = this.particleRollO;
        if (this.options.isFadeOut()) {
            this.quadSize = this.particleQuadSize * (1.0f - ((float)this.age + pticks) / (float)this.lifetime);
        }
        super.render(consumer, camera, pticks);
    }
}

