/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_boss.flying_block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FlyingBlockEntity
extends Entity {
    public static final EntityDataAccessor<BlockState> STATE = SynchedEntityData.defineId(FlyingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    public static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(FlyingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> FRICTION = SynchedEntityData.defineId(FlyingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public int noPhysicsTime = 0;

    public FlyingBlockEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        if (!this.level().isClientSide) {
            if (this.noPhysicsTime > 0) {
                --this.noPhysicsTime;
                this.noPhysics = true;
            } else {
                this.noPhysics = false;
            }
            if (this.tickCount >= 2000 || this.onGround() || this.getBlockState().isAir()) {
                this.discard();
            }
        }
        float friction = this.getAirFriction();
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)friction, 1.0, (double)friction));
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void setNoPhysicsTime(int noPhysicsTime) {
        this.noPhysicsTime = noPhysicsTime;
    }

    public int getNoPhysicsTime() {
        return this.noPhysicsTime;
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(rotationSpeed));
    }

    public float getAirFriction() {
        return ((Float)this.entityData.get(FRICTION)).floatValue();
    }

    public void setAirFriction(float friction) {
        this.entityData.set(FRICTION, (Object)Float.valueOf(friction));
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(STATE);
    }

    public void setBlockState(BlockState state) {
        this.entityData.set(STATE, (Object)state);
    }

    protected void playStepSound(BlockPos p_20135_, BlockState p_20136_) {
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    protected void defineSynchedData(SynchedEntityData.Builder data) {
        data.define(ROTATION_SPEED, (Object)Float.valueOf(1.0f)).define(FRICTION, (Object)Float.valueOf(1.0f)).define(STATE, (Object)Blocks.STONE.defaultBlockState());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        tag.putFloat("rotationSpeed", this.getRotationSpeed());
        tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlockState()));
        tag.putInt("noPhysicsTime", this.getNoPhysicsTime());
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.setRotationSpeed(tag.getFloat("rotationSpeed"));
        this.setBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("state")));
        this.setNoPhysicsTime(tag.getInt("noPhysicsTime"));
    }
}

