/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.chesed_sword_buff;

import com.finderfeed.fdbosses.content.entities.chesed_sword_buff.FlyingSwordEntity;
import com.finderfeed.fdlib.FDClientHelpers;
import com.finderfeed.fdlib.util.client.ColoredVertexConsumer;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;

public class FlyingSwordRenderer
extends EntityRenderer<FlyingSwordEntity> {
    public FlyingSwordRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(FlyingSwordEntity entity, float yaw, float pticks, PoseStack matrices, MultiBufferSource src, int light) {
        matrices.pushPose();
        float halfHeight = entity.getBbHeight() / 2.0f;
        matrices.translate(0.0f, halfHeight, 0.0f);
        int targetId = entity.getTargetIdForClient();
        ClientLevel clientLevel = (ClientLevel)FDClientHelpers.getClientLevel();
        Entity entity2 = clientLevel.getEntity(targetId);
        if (entity2 instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            Vec3 thisPos = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            Vec3 thatPos = entity.getTargetPos(target, pticks);
            Vec3 between = thatPos.subtract(thisPos);
            FDRenderUtil.applyMovementMatrixRotations((PoseStack)matrices, (Vec3)between);
        }
        float time = (float)entity.tickCount + pticks;
        float p = Math.clamp(time / (float)FlyingSwordEntity.DELAY_UNTIL_LAUNCH, 0.0f, 1.0f);
        float offset = -Mth.sin((float)(p * (float)Math.PI)) * 2.0f;
        matrices.translate(0.0f, offset, 0.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(FDEasings.easeOut((float)p) * 720.0f));
        matrices.mulPose(Axis.ZN.rotationDegrees(45.0f));
        float scale = Math.clamp(p * 2.0f, 0.0f, 1.0f);
        matrices.scale(scale, scale, scale);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        itemRenderer.render(entity.getItem(), ItemDisplayContext.FIXED, false, matrices, ColoredVertexConsumer.wrapBufferSource((MultiBufferSource)src, (int)5, (int)209, (int)255, (int)200), 0xF000F0, OverlayTexture.NO_OVERLAY, itemRenderer.getModel(entity.getItem(), entity.level(), (LivingEntity)Minecraft.getInstance().player, 0));
        matrices.popPose();
    }

    public ResourceLocation getTextureLocation(FlyingSwordEntity p_114482_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

