/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.judgement_ball_projectile;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.entities.geburah.judgement_ball_projectile.JudgementBallExplosionParticleOptions;
import com.finderfeed.fdbosses.init.BossModels;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class JudgementBallExplosionParticle
extends Particle {
    private static FDModel model;
    private JudgementBallExplosionParticleOptions options;
    public static final ParticleRenderType RENDER_TYPE;

    public JudgementBallExplosionParticle(ClientLevel p_107239_, double x, double y, double z, double xd, double yd, double zd, JudgementBallExplosionParticleOptions options) {
        super(p_107239_, x, y, z, xd, yd, zd);
        if (model == null) {
            model = new FDModel(BossModels.JUDGEMENT_BALL.get());
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.lifetime = Math.abs(options.lifetime);
        this.options = options;
    }

    public void render(VertexConsumer v, Camera camera, float pticks) {
        Vec3 ppos = FDMathUtil.interpolateVectors((Vec3)new Vec3(this.xo, this.yo, this.zo), (Vec3)new Vec3(this.x, this.y, this.z), (float)pticks);
        Vec3 realPos = ppos.subtract(camera.getPosition());
        PoseStack poseStack = new PoseStack();
        poseStack.translate(realPos.x, realPos.y, realPos.z);
        FDRenderUtil.applyMovementMatrixRotations((PoseStack)poseStack, (Vec3)this.options.movement);
        boolean inverted = this.options.lifetime < 0;
        float time = ((float)this.age + pticks) / (float)this.lifetime;
        float scale = (inverted ? 1.0f - time : FDEasings.easeOut((float)time)) * this.options.size;
        if (!inverted) {
            float rotation = (float)this.age + pticks;
            poseStack.mulPose(Axis.ZP.rotationDegrees(rotation * 20.0f));
        }
        poseStack.scale(scale, scale, scale);
        float alpha = 1.0f - FDEasings.easeOut((float)time);
        model.render(poseStack, v, 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, alpha * 0.9f);
    }

    public ParticleRenderType getRenderType() {
        return RENDER_TYPE;
    }

    static {
        RENDER_TYPE = new ParticleRenderType(){

            public BufferBuilder begin(Tesselator p_351047_, TextureManager p_107463_) {
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)FDBosses.location("textures/entities/geburah/judgement_ball_3.png"));
                RenderSystem.setShader(() -> GameRenderer.getParticleShader());
                return p_351047_.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            }

            public boolean isTranslucent() {
                return true;
            }

            public String toString() {
                return "GEBURAH_JUDGEMENT_BALL";
            }
        };
    }

    public static class Factory
    implements ParticleProvider<JudgementBallExplosionParticleOptions> {
        @Nullable
        public Particle createParticle(JudgementBallExplosionParticleOptions p_107421_, ClientLevel p_107422_, double x, double y, double z, double xd, double yd, double zd) {
            JudgementBallExplosionParticle particle = new JudgementBallExplosionParticle(p_107422_, x, y, z, xd, yd, zd, p_107421_);
            return particle;
        }
    }
}

