/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.respawn_point_setter_block;

import com.finderfeed.fdbosses.init.BossTileEntities;
import com.finderfeed.fdlib.data_structures.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GeburahRespiteBlock
extends GlazedTerracottaBlock
implements EntityBlock {
    public static final String DATA_NAME = "geburahRespawnData";

    public GeburahRespiteBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult p_60508_) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            GeburahRespiteBlock.putSpecialRespawnPoint(serverPlayer, (ResourceKey<Level>)serverPlayer.level().dimension(), serverPlayer.getOnPos().above());
            serverPlayer.sendSystemMessage((Component)Component.translatable((String)"fdbosses.word.set_special_respawn_point"));
            serverPlayer.swing(InteractionHand.MAIN_HAND);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, p_60508_);
    }

    public static CompoundTag getRespawnData(ServerPlayer serverPlayer) {
        CompoundTag perdata = serverPlayer.getPersistentData();
        if (perdata.contains(DATA_NAME)) {
            return perdata.getCompound(DATA_NAME);
        }
        return null;
    }

    public static void putRespawnData(ServerPlayer serverPlayer, CompoundTag tag) {
        CompoundTag perdata = serverPlayer.getPersistentData();
        perdata.put(DATA_NAME, (Tag)tag);
    }

    public static void putSpecialRespawnPoint(ServerPlayer serverPlayer, ResourceKey<Level> dimension, BlockPos pos) {
        CompoundTag tag;
        CompoundTag perdata = serverPlayer.getPersistentData();
        if (!perdata.contains(DATA_NAME)) {
            tag = new CompoundTag();
            perdata.put(DATA_NAME, (Tag)tag);
        }
        tag = perdata.getCompound(DATA_NAME);
        tag.putInt("x", pos.getX());
        tag.putInt("y", pos.getY());
        tag.putInt("z", pos.getZ());
        tag.putString("dimension", dimension.location().toString());
    }

    public static Pair<ResourceKey<Level>, BlockPos> getSpecialRespawnPoint(ServerPlayer serverPlayer) {
        CompoundTag perdata = serverPlayer.getPersistentData();
        if (!perdata.contains(DATA_NAME)) {
            return null;
        }
        CompoundTag data = perdata.getCompound(DATA_NAME);
        int x = data.getInt("x");
        int y = data.getInt("y");
        int z = data.getInt("z");
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)data.getString("dimension")));
        return new Pair((Object)dimension, (Object)new BlockPos(x, y, z));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BossTileEntities.GEBURAH_RESPITE_BLOCK.get().create(pos, state);
    }
}

