/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons;

import com.finderfeed.fdbosses.content.entities.geburah.GeburahEntity;
import com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons.GeburahWeaponRotationSyncPacket;
import com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons.StopGeburahWeaponRotationPacket;
import com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons.rotations.GeburahConstantWeaponRotation;
import com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons.rotations.GeburahWeaponRotation;
import com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons.rotations.GeburahWeaponsRotateTo;
import com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons.rotations.StartGeburahWeaponRotationPacket;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;

public class GeburahWeaponRotationController {
    private GeburahEntity geburah;
    public float currentRotation = 0.0f;
    protected float oldRotation = 0.0f;
    private float rotationForSound = 0.0f;
    protected GeburahWeaponRotation weaponRotation;

    public GeburahWeaponRotationController(GeburahEntity geburah) {
        this.geburah = geburah;
    }

    public void tick() {
        this.oldRotation = this.currentRotation;
        if (this.weaponRotation != null) {
            this.weaponRotation.tick();
            if (this.weaponRotation.shouldPlayRotationSound()) {
                this.playRotationSound();
            }
            if (this.weaponRotation.finishedRotation()) {
                this.weaponRotation = null;
                this.trySendRotationSyncPacket();
            }
        }
    }

    private void playRotationSound() {
        if (!this.geburah.level().isClientSide) {
            this.rotationForSound += Math.abs(this.currentRotation - this.oldRotation);
            float distForSound = 20.0f;
            if (this.rotationForSound > distForSound) {
                this.rotationForSound %= distForSound;
                this.geburah.level().playSound(null, this.geburah.getX(), this.geburah.getY(), this.geburah.getZ(), BossSounds.GEBURAH_WEAPON_ROTATION_CLING.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            }
        }
    }

    public void rotateWeapons(GeburahWeaponRotation geburahWeaponRotation) {
        geburahWeaponRotation.setRotatingWeaponsHandler(this);
        if (!this.geburah.level().isClientSide) {
            if (this.weaponRotation != null) {
                this.trySendRotationSyncPacket();
            }
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this.geburah, (CustomPacketPayload)new StartGeburahWeaponRotationPacket(this.geburah, geburahWeaponRotation), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.weaponRotation = geburahWeaponRotation;
    }

    public void rotateWeaponsBy(float rotationDelta, int rotationTime, boolean easeInOut) {
        this.rotateWeapons(new GeburahWeaponsRotateTo(this, this.currentRotation + rotationDelta, rotationTime, easeInOut));
    }

    public void rotateWeaponsBy(float rotationDelta, int rotationTime) {
        this.rotateWeaponsBy(rotationDelta, rotationTime, false);
    }

    public void startConstantRotation(float rotationSpeed) {
        GeburahConstantWeaponRotation constantWeaponRotation;
        float currentRotSpeed;
        GeburahWeaponRotation geburahWeaponRotation = this.weaponRotation;
        if (geburahWeaponRotation instanceof GeburahConstantWeaponRotation && (currentRotSpeed = (constantWeaponRotation = (GeburahConstantWeaponRotation)geburahWeaponRotation).getRotationSpeed()) == rotationSpeed) {
            return;
        }
        this.rotateWeapons(new GeburahConstantWeaponRotation(rotationSpeed));
    }

    public void stopRotation() {
        this.weaponRotation = null;
        if (!this.geburah.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this.geburah, (CustomPacketPayload)new StopGeburahWeaponRotationPacket(this.geburah), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.trySendRotationSyncPacket();
        }
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public float getOldRotation() {
        return this.oldRotation;
    }

    public void setRotation(float rotation) {
        this.oldRotation = this.currentRotation;
        this.currentRotation = rotation;
        this.trySendRotationSyncPacket();
    }

    public float getLerpedRotation(float pticks) {
        return FDMathUtil.lerp((float)this.oldRotation, (float)this.currentRotation, (float)pticks);
    }

    public GeburahWeaponRotation getWeaponRotation() {
        return this.weaponRotation;
    }

    public boolean finishedRotation() {
        return this.weaponRotation == null || this.weaponRotation.finishedRotation();
    }

    public void onStartSeeingGeburah(ServerPlayer serverPlayer) {
        GeburahWeaponRotationSyncPacket syncPacket = new GeburahWeaponRotationSyncPacket(this.geburah);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)syncPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.weaponRotation != null) {
            StartGeburahWeaponRotationPacket geburahWeaponRotationPacket = new StartGeburahWeaponRotationPacket(this.geburah, this.weaponRotation);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)geburahWeaponRotationPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void trySendRotationSyncPacket() {
        if (!this.geburah.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this.geburah, (CustomPacketPayload)new GeburahWeaponRotationSyncPacket(this.geburah), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

