/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons;

import com.finderfeed.fdbosses.BossClientPackets;
import com.finderfeed.fdbosses.content.entities.geburah.GeburahEntity;
import com.finderfeed.fdbosses.content.entities.geburah.rotating_weapons.GeburahWeaponRotationController;
import com.finderfeed.fdlib.network.FDPacket;
import com.finderfeed.fdlib.network.RegisterFDPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@RegisterFDPacket(value="fdbosses:weapon_rotation_sync")
public class GeburahWeaponRotationSyncPacket
extends FDPacket {
    private int entityId;
    private float currentRotation;

    public GeburahWeaponRotationSyncPacket(GeburahEntity geburah) {
        float currentRotation;
        GeburahWeaponRotationController rotatingWeaponsHandler = geburah.getWeaponRotationController();
        this.currentRotation = currentRotation = rotatingWeaponsHandler.getCurrentRotation();
        this.entityId = geburah.getId();
    }

    public GeburahWeaponRotationSyncPacket(RegistryFriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.currentRotation = buf.readFloat();
    }

    public void write(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        registryFriendlyByteBuf.writeInt(this.entityId);
        registryFriendlyByteBuf.writeFloat(this.currentRotation);
    }

    public void clientAction(IPayloadContext iPayloadContext) {
        BossClientPackets.handleGeburahWeaponRotationSync(this.entityId, this.currentRotation);
    }

    public void serverAction(IPayloadContext iPayloadContext) {
    }
}

