/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.scales_controller;

import com.finderfeed.fdbosses.content.entities.geburah.GeburahEntity;
import com.finderfeed.fdbosses.content.entities.geburah.scales_controller.GeburahScalesControllerSetDisplacement;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class GeburahScalesController
implements AutoSerializable {
    public static final int MAX_DISPLACEMENT = 5;
    @SerializableField
    private int currentDisplacement = 0;
    private int oldDisplacement = 0;
    private int displacementTime = -1;
    private int displacementMaxTime = -1;
    public GeburahEntity geburah;

    public GeburahScalesController(GeburahEntity geburah) {
        this.geburah = geburah;
    }

    public void tick() {
        Level level = this.geburah.level();
        if (level.isClientSide) {
            this.clientTick();
        }
    }

    private void clientTick() {
        if (this.displacementTime == -1 || this.displacementMaxTime == -1) {
            this.oldDisplacement = this.currentDisplacement;
        } else {
            ++this.displacementTime;
            if (this.displacementTime >= this.displacementMaxTime) {
                this.displacementTime = -1;
                this.displacementMaxTime = -1;
                this.oldDisplacement = this.currentDisplacement;
            }
        }
    }

    public float getClientDisplacementAngle(float pticks) {
        float anglePerDisplacement = 5.0f;
        if (this.displacementTime == -1) {
            return (float)this.currentDisplacement * anglePerDisplacement;
        }
        float p = Mth.clamp((float)((float)this.displacementTime + pticks), (float)0.0f, (float)this.displacementMaxTime) / (float)this.displacementMaxTime;
        p = this.displacementMaxTime < 40 ? FDEasings.easeOutBack((float)p) : FDEasings.easeInOut((float)p);
        return FDMathUtil.lerp((float)this.oldDisplacement, (float)this.currentDisplacement, (float)p) * anglePerDisplacement;
    }

    public void setCurrentDisplacement(int currentDisplacement, int displacementTime) {
        currentDisplacement = Mth.clamp((int)currentDisplacement, (int)-5, (int)5);
        if (!this.geburah.level().isClientSide) {
            if (this.currentDisplacement != currentDisplacement) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this.geburah, (CustomPacketPayload)new GeburahScalesControllerSetDisplacement(this.geburah, currentDisplacement, displacementTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            if (this.displacementMaxTime != -1 || this.displacementTime != -1) {
                this.oldDisplacement = this.currentDisplacement;
            }
            this.displacementMaxTime = displacementTime;
            this.displacementTime = 0;
        }
        this.currentDisplacement = currentDisplacement;
    }

    public int getCurrentDisplacement() {
        return this.currentDisplacement;
    }

    public void syncToPlayer(ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new GeburahScalesControllerSetDisplacement(this.geburah, this.currentDisplacement, 100), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

