/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_crush;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.finderfeed.fdbosses.client.particles.smoke_particle.BigSmokeParticleOptions;
import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossBuddy;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector3f;

public class MalkuthCrushAttack
extends FDEntity
implements AutoSerializable {
    public static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.defineId(MalkuthCrushAttack.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    public static final EntityDataAccessor<Byte> VISUAL_APPEARANCE = SynchedEntityData.defineId(MalkuthCrushAttack.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    @SerializableField
    private float damage;

    public static MalkuthCrushAttack summon(Level level, Vec3 pos, float damage) {
        return MalkuthCrushAttack.summon(level, pos, damage, Direction.UP, null);
    }

    public static MalkuthCrushAttack summon(Level level, Vec3 pos, float damage, Direction direction, MalkuthAttackType visualAppearance) {
        MalkuthCrushAttack malkuthCrushAttack = new MalkuthCrushAttack(BossEntities.MALKUTH_CRUSH.get(), level);
        malkuthCrushAttack.setPos(pos);
        malkuthCrushAttack.damage = damage;
        malkuthCrushAttack.entityData.set(DIRECTION, (Object)direction);
        if (visualAppearance != null) {
            if (visualAppearance.isFire()) {
                malkuthCrushAttack.entityData.set(VISUAL_APPEARANCE, (Object)1);
            } else {
                malkuthCrushAttack.entityData.set(VISUAL_APPEARANCE, (Object)2);
            }
        }
        level.addFreshEntity((Entity)malkuthCrushAttack);
        return malkuthCrushAttack;
    }

    public MalkuthCrushAttack(EntityType<?> type, Level level) {
        super(type, level);
        this.getAnimationSystem().startAnimation("ATTACK", AnimationTicker.builder(BossAnims.MALKUTH_CRUSH_ATTACK_CRUSH).setSpeed(1.25f).build());
    }

    public void tick() {
        if (this.firstTick) {
            if (this.level().isClientSide) {
                this.doParticles();
            } else {
                this.doDamage();
            }
        }
        super.tick();
        if (!this.level().isClientSide && this.tickCount > ((Animation)BossAnims.MALKUTH_CRUSH_ATTACK_CRUSH.get()).getAnimTime() - 10) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean isBothFireAndIce() {
        return (Byte)this.entityData.get(VISUAL_APPEARANCE) == 0;
    }

    public boolean isFire() {
        return (Byte)this.entityData.get(VISUAL_APPEARANCE) == 1;
    }

    public boolean isIce() {
        return (Byte)this.entityData.get(VISUAL_APPEARANCE) == 2;
    }

    private void doDamage() {
        if (this.damage == 0.0f) {
            return;
        }
        float radius = 4.0f;
        Predicate<LivingEntity> entityPredicate = v -> !(v instanceof MalkuthBossBuddy);
        List<LivingEntity> targets = BossTargetFinder.getEntitiesInCylinder(LivingEntity.class, this.level(), this.position(), 2.0f, radius, entityPredicate);
        for (LivingEntity target : targets) {
            target.hurt(BossDamageSources.MALKUTH_EARTHSHATTER_SOURCE, this.damage);
            Vec3 speed = target.position().subtract(this.position()).multiply(1.0, 0.0, 1.0).normalize().multiply(2.0, 0.0, 2.0).add(0.0, 1.5, 0.0);
            if (target instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)target;
                FDLibCalls.setServerPlayerSpeed((ServerPlayer)player, (Vec3)speed);
                continue;
            }
            target.setDeltaMovement(speed);
        }
    }

    private void doParticles() {
        int i;
        int count = 30;
        Vec3i nrm = ((Direction)this.getEntityData().get(DIRECTION)).getNormal();
        Vec3 v = new Vec3((double)nrm.getX(), (double)nrm.getY(), (double)nrm.getZ());
        Matrix4f mat = new Matrix4f();
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mat, (Vec3)v);
        float angle = (float)Math.PI * 2 / (float)count;
        for (i = 0; i < count; ++i) {
            Vector2d randomAngle;
            float m;
            float dist;
            float currentAngle = angle * (float)i;
            for (dist = 0.0f; dist < 3.0f; dist += 0.5f) {
                float b;
                float g;
                float r;
                m = dist + this.random.nextFloat() * 0.25f;
                randomAngle = this.randomAngle(angle, currentAngle);
                if (this.isBothFireAndIce()) {
                    if (this.random.nextFloat() > 0.5f) {
                        r = this.random.nextFloat() * 0.2f;
                        g = 0.7f + this.random.nextFloat() * 0.1f;
                        b = 0.9f + this.random.nextFloat() * 0.1f;
                    } else {
                        r = 0.9f + this.random.nextFloat() * 0.1f;
                        g = 0.2f + this.random.nextFloat() * 0.2f;
                        b = this.random.nextFloat() * 0.2f;
                    }
                } else if (this.isFire()) {
                    r = 0.9f + this.random.nextFloat() * 0.1f;
                    g = 0.2f + this.random.nextFloat() * 0.2f;
                    b = this.random.nextFloat() * 0.2f;
                } else {
                    r = this.random.nextFloat() * 0.2f;
                    g = 0.7f + this.random.nextFloat() * 0.1f;
                    b = 0.9f + this.random.nextFloat() * 0.1f;
                }
                BallParticleOptions ballParticleOptions = BallParticleOptions.builder().size(0.2f + this.random.nextFloat() * 0.2f).color(r, g, b).scalingOptions(0, 0, 10 + this.random.nextInt(4)).friction(0.6f).build();
                float hspeed = (0.1f + this.random.nextFloat() * 0.2f) * 2.0f;
                float vspeed = (0.05f + this.random.nextFloat() * 0.5f) * 2.0f;
                Vec3 speed = BossUtil.matTransformDirectionVec3(mat, new Vec3(randomAngle.x * (double)hspeed, (double)vspeed, randomAngle.y * (double)hspeed));
                Vec3 spOffset = BossUtil.matTransformDirectionVec3(mat, new Vec3(randomAngle.x * (double)m, 0.0, randomAngle.y * (double)m));
                this.level().addParticle((ParticleOptions)ballParticleOptions, true, this.getX() + spOffset.x, this.getY() + spOffset.y, this.getZ() + spOffset.z, speed.x, speed.y, speed.z);
            }
            for (dist = 1.0f; dist < 3.5f; dist += 1.0f) {
                m = dist + this.random.nextFloat() * 0.5f;
                randomAngle = this.randomAngle(angle, currentAngle);
                if (this.random.nextFloat() > 0.66f) {
                    if (this.isIce()) continue;
                    this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, true, this.getX() + randomAngle.x * (double)m, this.getY(), this.getZ() + randomAngle.y * (double)m, 0.0, 0.0, 0.0);
                    continue;
                }
                GravityParticleOptions particleOptions = this.isBothFireAndIce() ? (this.random.nextFloat() > 0.5f ? new GravityParticleOptions(BossParticles.FLAME_WITH_STONE.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true) : new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true)) : (this.isFire() ? new GravityParticleOptions(BossParticles.FLAME_WITH_STONE.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true) : new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true));
                float hspeed = 0.1f + this.random.nextFloat() * 0.05f;
                float vspeed = 0.4f + this.random.nextFloat() * 0.25f;
                Vec3 speed = BossUtil.matTransformDirectionVec3(mat, new Vec3(randomAngle.x * (double)hspeed, (double)vspeed, randomAngle.y * (double)hspeed));
                Vec3 spOffset = BossUtil.matTransformDirectionVec3(mat, new Vec3(randomAngle.x * (double)m, 0.0, randomAngle.y * (double)m));
                this.level().addParticle((ParticleOptions)particleOptions, true, this.getX() + spOffset.x, this.getY() + spOffset.y, this.getZ() + spOffset.z, speed.x, speed.y, speed.z);
            }
            Vector2d randomAngle2 = this.randomAngle(angle, currentAngle);
            int cr = this.random.nextInt(50);
            BigSmokeParticleOptions smokeParticleOptions = BigSmokeParticleOptions.builder().size(1.0f + this.random.nextFloat() * 0.5f).friction(0.75f).minSpeed(0.025f).color(50 + cr, 50 + cr, 50 + cr).lifetime(0, 5, 30 + this.random.nextInt(5)).build();
            float rndOffs = this.random.nextFloat() * 0.5f;
            float rndSpeed = this.random.nextFloat() * 1.0f + 0.25f;
            Vec3 speed = BossUtil.matTransformDirectionVec3(mat, new Vec3(randomAngle2.x * (double)rndSpeed, (double)(this.random.nextFloat() * 0.025f + 0.025f), randomAngle2.y * (double)rndSpeed));
            Vec3 spOffset = BossUtil.matTransformDirectionVec3(mat, new Vec3(randomAngle2.x * (double)rndOffs, (double)(this.random.nextFloat() * 0.5f), randomAngle2.y * (double)rndOffs));
            this.level().addParticle((ParticleOptions)smokeParticleOptions, true, this.getX() + spOffset.x, this.getY() + spOffset.y, this.getZ() + spOffset.z, speed.x, speed.y, speed.z);
        }
        for (i = 0; i < 15; ++i) {
            if (this.isBothFireAndIce()) {
                this.stripeParticles(mat, MalkuthAttackType.FIRE);
                this.stripeParticles(mat, MalkuthAttackType.ICE);
                continue;
            }
            if (this.isFire()) {
                this.stripeParticles(mat, MalkuthAttackType.FIRE);
                this.stripeParticles(mat, MalkuthAttackType.FIRE);
                continue;
            }
            this.stripeParticles(mat, MalkuthAttackType.ICE);
            this.stripeParticles(mat, MalkuthAttackType.ICE);
        }
    }

    private void stripeParticles(Matrix4f mat, MalkuthAttackType type) {
        float rndRadius = 1.0f + FDEasings.easeOut((float)this.random.nextFloat()) * 4.0f;
        Vec3 rnd = new Vec3((double)rndRadius, 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat());
        Vec3 dir = rnd.normalize();
        float startOffsetRand = 0.1f + this.random.nextFloat() * 0.5f;
        Vec3 startOffset = dir.multiply((double)startOffsetRand, (double)startOffsetRand, (double)startOffsetRand);
        Vec3 stripePos = this.position().add(BossUtil.matTransformDirectionVec3(mat, startOffset));
        Vector3f colFire = MalkuthEntity.getMalkuthAttackPreparationParticleColor(type);
        FDColor fireColorStart = new FDColor(colFire.x, colFire.y - this.random.nextFloat() * 0.1f - 0.3f, colFire.z, 0.5f);
        FDColor fireColor = new FDColor(colFire.x, colFire.y + this.random.nextFloat() * 0.1f, colFire.z, 1.0f);
        float firstPointOffset = 2.0f + this.random.nextFloat() * 1.0f;
        StripeParticleOptions stripeParticleOptions = new StripeParticleOptions(fireColorStart, fireColor, 5 + this.random.nextInt(10), 50, 0.05f, 0.75f, BossUtil.matTransformDirectionVec3(mat, new Vec3((double)0.01f, 0.0, 0.0)), BossUtil.matTransformDirectionVec3(mat, dir.multiply((double)firstPointOffset, 0.0, (double)firstPointOffset).add(0.0, 0.5, 0.0)), BossUtil.matTransformDirectionVec3(mat, rnd.add(0.0, (double)(1.5f + this.random.nextFloat() * 2.0f), 0.0)));
        this.level().addParticle((ParticleOptions)stripeParticleOptions, true, stripePos.x, stripePos.y, stripePos.z, 0.0, 0.0, 0.0);
    }

    private Vector2d randomAngle(float angle, float currentAngle) {
        float a = currentAngle + (this.random.nextFloat() * 2.0f - 1.0f) * angle / 2.0f;
        return new Vector2d(Math.sin(a), Math.cos(a));
    }

    protected void defineSynchedData(SynchedEntityData.Builder data) {
        data.define(DIRECTION, (Object)Direction.UP);
        data.define(VISUAL_APPEARANCE, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.autoSave(tag);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.autoLoad(tag);
    }

    public boolean shouldRenderAtSqrDistance(double dist) {
        return dist <= 3600.0;
    }
}

