/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_repair_crystal;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_cannon.MalkuthCannonEntity;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdlib.util.ProjectileMovementPath;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MalkuthRepairEntity
extends Entity {
    public static final EntityDataAccessor<Integer> RANDOMIZED_DIRECTION = SynchedEntityData.defineId(MalkuthRepairEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<MalkuthAttackType> ATTACK_TYPE = SynchedEntityData.defineId(MalkuthRepairEntity.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    private ProjectileMovementPath movementPath;
    private MalkuthCannonEntity flyingTo = null;

    public static MalkuthRepairEntity summon(Level level, Vec3 pos, MalkuthAttackType repairEntityType) {
        MalkuthRepairEntity repairEntity = new MalkuthRepairEntity(BossEntities.MALKUTH_REPAIR_ENTITY.get(), level);
        repairEntity.setPos(pos);
        repairEntity.entityData.set(ATTACK_TYPE, (Object)repairEntityType);
        level.addFreshEntity((Entity)repairEntity);
        return repairEntity;
    }

    public MalkuthRepairEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        this.setPos(this.position().add(this.getDeltaMovement()));
        if (!this.level().isClientSide) {
            this.tickMovementPath();
        } else {
            Vector3f color = MalkuthEntity.getAndRandomizeColor((MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE)), this.level().random);
            BallParticleOptions options = BallParticleOptions.builder().color(color.x, color.y, color.z).brightness(2).scalingOptions(0, 0, 10).size(0.15f).build();
            this.level().addParticle((ParticleOptions)options, true, this.xo, this.yo, this.zo, 0.0, 0.0, 0.0);
        }
    }

    private void tickMovementPath() {
        if (this.movementPath == null && !this.initMovementPath()) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!this.movementPath.isFinished()) {
            this.movementPath.tick((Entity)this);
        } else {
            this.flyingTo.repairWithMaterial();
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private boolean initMovementPath() {
        MalkuthAttackType type = (MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE));
        List<MalkuthCannonEntity> cannons = BossTargetFinder.getEntitiesInSphere(MalkuthCannonEntity.class, this.level(), this.position(), 30.0f, cannon -> cannon.getCannonType().equals((Object)type) && cannon.isPlayerControlled());
        if (cannons.isEmpty()) {
            return false;
        }
        this.flyingTo = cannons.getFirst();
        Vec3 startPos = this.position();
        Vec3 endPos = this.flyingTo.position().add(0.0, 1.0, 0.0);
        Vec3 b = endPos.subtract(startPos);
        Vec3 left = b.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        if (this.random.nextFloat() > 0.5f) {
            left = left.reverse();
            this.entityData.set(RANDOMIZED_DIRECTION, (Object)-1);
        }
        Vec3 bp1 = startPos.add(b.multiply(0.25, 0.25, 0.25)).add(left.multiply(1.5, 1.5, 1.5));
        Vec3 bp2 = startPos.add(b.multiply(0.5, 0.5, 0.5)).add(left.multiply(2.0, 2.0, 2.0));
        Vec3 bp3 = startPos.add(b.multiply(0.75, 0.75, 0.75)).add(left.multiply(1.5, 1.5, 1.5));
        List<Vector3f> positions = new ArrayList<Vec3>(List.of(startPos, bp1, bp2, bp3, endPos)).stream().map(Vec3::toVector3f).toList();
        this.movementPath = new ProjectileMovementPath(20, false);
        int segments = 20;
        for (int k = 0; k < segments; ++k) {
            float p = (float)k / ((float)segments - 1.0f);
            Vector3f p1 = FDMathUtil.catmullRom(positions, (float)p);
            this.movementPath.addPos(new Vec3(p1));
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p) {
        p.define(ATTACK_TYPE, (Object)MalkuthAttackType.FIRE);
        p.define(RANDOMIZED_DIRECTION, (Object)1);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("attackType")) {
            this.entityData.set(ATTACK_TYPE, (Object)MalkuthAttackType.valueOf(tag.getString("attackType")));
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("attackType", ((MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE))).name());
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }

    public boolean shouldRender(double p_20296_, double p_20297_, double p_20298_) {
        return super.shouldRender(p_20296_, p_20297_, p_20298_);
    }

    public boolean isCurrentlyGlowing() {
        return true;
    }

    public int getTeamColor() {
        return ((MalkuthAttackType)((Object)this.entityData.get(ATTACK_TYPE))).isFire() ? 0xFFBB11 : 0x11AAFF;
    }
}

