/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.runetablets.network;

import java.util.function.Supplier;
import net.mcreator.runetablets.RuneTabletsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RuneTabletsModVariables {
    public static double minutes = 0.0;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        RuneTabletsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handleData);
        RuneTabletsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int dataType;
        private final SavedData data;

        public SavedDataSyncMessage(int dataType, SavedData data) {
            this.dataType = dataType;
            this.data = data;
        }

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt);
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt);
                }
            }
            this.dataType = dataType;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handleData(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.m_7176_(new CompoundTag()));
                    } else {
                        WorldVariables.clientSide.read(message.data.m_7176_(new CompoundTag()));
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) {
        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.m_130260_());
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data().serializeNBT());
        }

        public static void handleData(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES).ifPresent(cap -> cap.deserializeNBT(message.data.serializeNBT()));
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public double Xspawn = 0.0;
        public double Yspawn = 0.0;
        public double Zspawn = 0.0;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("Xspawn", this.Xspawn);
            nbt.m_128347_("Yspawn", this.Yspawn);
            nbt.m_128347_("Zspawn", this.Zspawn);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.Xspawn = nbt.m_128459_("Xspawn");
            this.Yspawn = nbt.m_128459_("Yspawn");
            this.Zspawn = nbt.m_128459_("Zspawn");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("rune_tablets", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES ? this.instance.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.playerVariables.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerVariables.deserializeNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "rune_tablets_mapvars";
        boolean _syncDirty = false;
        public double seconds = 0.0;
        public boolean grassrightclick = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.seconds = nbt.m_128459_("seconds");
            this.grassrightclick = nbt.m_128471_("grassrightclick");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("seconds", this.seconds);
            nbt.m_128379_("grassrightclick", this.grassrightclick);
            return nbt;
        }

        public void markSyncDirty() {
            this.m_77762_();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "rune_tablets_worldvars";
        boolean _syncDirty = false;
        public boolean rightclick = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.rightclick = nbt.m_128471_("rightclick");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("rightclick", this.rightclick);
            return nbt;
        }

        public void markSyncDirty() {
            this.m_77762_();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerTickUpdateSyncPlayerVariables(TickEvent.PlayerTickEvent event) {
            Player player;
            if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> {
                    if (capability._syncDirty) {
                        RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability));
                        capability._syncDirty = false;
                    }
                });
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            event.getOriginal().getCapability(PLAYER_VARIABLES).ifPresent(original -> event.getEntity().getCapability(PLAYER_VARIABLES).ifPresent(clone -> {
                clone.Xspawn = original.Xspawn;
                clone.Yspawn = original.Yspawn;
                clone.Zspawn = original.Zspawn;
                if (!event.isWasDeath()) {
                    // empty if block
                }
            }));
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)player2.m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)player2.m_9236_());
                if (mapdata != null) {
                    RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            ServerPlayer player;
            WorldVariables worlddata;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && (worlddata = WorldVariables.get((LevelAccessor)(player = (ServerPlayer)player2).m_9236_())) != null) {
                RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.LevelTickEvent event) {
            Level level;
            if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
                if (worldVariables._syncDirty) {
                    RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level2).m_46472_()), (Object)new SavedDataSyncMessage(1, worldVariables));
                    worldVariables._syncDirty = false;
                }
                MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
                if (mapVariables._syncDirty) {
                    RuneTabletsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, mapVariables));
                    mapVariables._syncDirty = false;
                }
            }
        }
    }
}

