/*
 * Decompiled with CFR 0.152.
 */
package net.hicham.screenshotgallery.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ScreenshotGalleryConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("screenshotgallery.json").toFile();
    private static ScreenshotGalleryConfig INSTANCE;
    public GridSize gridSize = GridSize.MEDIUM;
    public ThumbnailSize thumbnailSize = ThumbnailSize.MEDIUM;
    public boolean autoRefresh = true;
    public boolean fadeAnimations = true;
    public RefreshSpeed refreshSpeed = RefreshSpeed.NORMAL;

    private void ensureDefaults() {
        if (this.gridSize == null) {
            this.gridSize = GridSize.MEDIUM;
        }
        if (this.thumbnailSize == null) {
            this.thumbnailSize = ThumbnailSize.MEDIUM;
        }
        if (this.refreshSpeed == null) {
            this.refreshSpeed = RefreshSpeed.NORMAL;
        }
    }

    public static ScreenshotGalleryConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ScreenshotGalleryConfig.load();
        }
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ScreenshotGalleryConfig load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                ScreenshotGalleryConfig config = (ScreenshotGalleryConfig)GSON.fromJson((Reader)reader, ScreenshotGalleryConfig.class);
                if (config != null) {
                    config.ensureDefaults();
                    ScreenshotGalleryConfig screenshotGalleryConfig = config;
                    return screenshotGalleryConfig;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ScreenshotGalleryConfig config = new ScreenshotGalleryConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getColumns() {
        return this.gridSize != null ? this.gridSize.getColumns() : GridSize.MEDIUM.getColumns();
    }

    public int getThumbnailSize() {
        return this.thumbnailSize != null ? this.thumbnailSize.getSize() : ThumbnailSize.MEDIUM.getSize();
    }

    public int getRefreshIntervalMs() {
        return this.refreshSpeed != null ? this.refreshSpeed.getIntervalMs() : RefreshSpeed.NORMAL.getIntervalMs();
    }

    public static enum GridSize {
        SMALL("Small (3 columns)", 3),
        MEDIUM("Medium (4 columns)", 4),
        LARGE("Large (6 columns)", 6);

        private final String displayName;
        private final int columns;

        private GridSize(String displayName, int columns) {
            this.displayName = displayName;
            this.columns = columns;
        }

        public int getColumns() {
            return this.columns;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum ThumbnailSize {
        SMALL("Small (48px)", 48),
        MEDIUM("Medium (64px)", 64),
        LARGE("Large (96px)", 96);

        private final String displayName;
        private final int size;

        private ThumbnailSize(String displayName, int size) {
            this.displayName = displayName;
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public String toString() {
            return this.displayName;
        }
    }

    public static enum RefreshSpeed {
        FAST("Fast (1 second)", 1000),
        NORMAL("Normal (2 seconds)", 2000),
        SLOW("Slow (5 seconds)", 5000);

        private final String displayName;
        private final int intervalMs;

        private RefreshSpeed(String displayName, int intervalMs) {
            this.displayName = displayName;
            this.intervalMs = intervalMs;
        }

        public int getIntervalMs() {
            return this.intervalMs;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

