/*
 * Decompiled with CFR 0.152.
 */
package net.hicham.screenshotgallery.gui;

import java.io.File;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.hicham.screenshotgallery.config.ScreenshotGalleryConfig;
import net.hicham.screenshotgallery.util.ImageUtils;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.lwjgl.glfw.GLFW;

public class GalleryScreen
extends class_437 {
    private final class_437 parent;
    private File selectedImage = null;
    private class_2960 selectedImageId = null;
    private int selectedImageIndex = -1;
    private File[] allScreenshots = new File[0];
    private static final int PADDING = 10;
    private static final int LIST_TOP = 32;
    private final Map<File, CompletableFuture<Void>> loadingFutures = new HashMap<File, CompletableFuture<Void>>();
    private final Map<File, class_2960> textureCache = new HashMap<File, class_2960>();
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private SortMode sortMode = SortMode.DATE_DESC;
    private class_4185 sortButton;
    private String feedbackMessage = null;
    private long feedbackExpiry = 0L;
    private float fadeAlpha = 0.0f;
    private boolean isFadingIn = false;
    private boolean isFadingOut = false;
    private static final float FADE_SPEED = 0.15f;
    private long lastRefreshTime = 0L;
    private int lastScreenshotCount = 0;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean wasMouseDown = false;

    private int getColumns() {
        return ScreenshotGalleryConfig.getInstance().getColumns();
    }

    private int getThumbSize() {
        return ScreenshotGalleryConfig.getInstance().getThumbnailSize();
    }

    private long getRefreshIntervalMs() {
        return ScreenshotGalleryConfig.getInstance().getRefreshIntervalMs();
    }

    public GalleryScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Screenshot Gallery"));
        this.parent = parent;
    }

    protected void method_25426() {
        if (this.selectedImage != null) {
            this.initFullscreen();
            return;
        }
        this.initGallery();
    }

    private void initFullscreen() {
        this.method_37067();
        int buttonY = this.field_22790 - 30;
        int center = this.field_22789 / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0 Prev"), button -> this.navigateImage(-1)).method_46434(center - 210, buttonY, 50, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.closeFullscreen()).method_46434(center - 155, buttonY, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Copy"), button -> {
            ImageUtils.copyImageToClipboard(this.selectedImage);
            this.showFeedback("Copied to clipboard!");
        }).method_46434(center - 50, buttonY, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), button -> this.confirmDelete()).method_46434(center + 55, buttonY, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Next \u25b6"), button -> this.navigateImage(1)).method_46434(center + 160, buttonY, 50, 20).method_46431());
    }

    private void initGallery() {
        this.method_37067();
        int bottomY = this.field_22790 - 28;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open Folder"), button -> class_156.method_668().method_672(new File(this.field_22787.field_1697, "screenshots"))).method_46434(20, bottomY, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - 50, bottomY, 100, 20).method_46431());
        this.sortButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Sort: " + this.sortMode.getDisplayName())), button -> {
            this.cycleSortMode();
            this.loadScreenshots();
        }).method_46434(this.field_22789 - 150, bottomY, 130, 20).method_46431();
        this.method_37063((class_364)this.sortButton);
        this.loadScreenshots();
    }

    private void cycleSortMode() {
        this.sortMode = SortMode.values()[(this.sortMode.ordinal() + 1) % SortMode.values().length];
        if (this.sortButton != null) {
            this.sortButton.method_25355((class_2561)class_2561.method_43470((String)("Sort: " + this.sortMode.getDisplayName())));
        }
    }

    private void loadScreenshots() {
        File screenshotDir = new File(this.field_22787.field_1697, "screenshots");
        if (!screenshotDir.exists() || !screenshotDir.isDirectory()) {
            this.allScreenshots = new File[0];
            return;
        }
        File[] files = screenshotDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".png"));
        if (files == null) {
            this.allScreenshots = new File[0];
            return;
        }
        Arrays.sort(files, (f1, f2) -> switch (this.sortMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Long.compare(f2.lastModified(), f1.lastModified());
            case 1 -> Long.compare(f1.lastModified(), f2.lastModified());
            case 2 -> f1.getName().compareToIgnoreCase(f2.getName());
            case 3 -> f2.getName().compareToIgnoreCase(f1.getName());
        });
        this.allScreenshots = files;
        int rowCount = (this.allScreenshots.length + this.getColumns() - 1) / this.getColumns();
        int contentHeight = rowCount * (this.getThumbSize() + 10);
        int viewableHeight = this.field_22790 - 32 - 50;
        this.maxScrollOffset = Math.max(0, contentHeight - viewableHeight);
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScrollOffset);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1073741824);
        if (this.selectedImage != null && this.selectedImageId != null) {
            this.renderFullscreenView(context, mouseX, mouseY);
        } else {
            this.renderGalleryView(context, mouseX, mouseY);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.feedbackMessage != null && System.currentTimeMillis() < this.feedbackExpiry) {
            int msgWidth = this.field_22793.method_1727(this.feedbackMessage);
            int msgX = (this.field_22789 - msgWidth) / 2;
            int msgY = this.field_22790 / 2 + 50;
            context.method_25294(msgX - 5, msgY - 3, msgX + msgWidth + 5, msgY + 12, -1442840576);
            context.method_51433(this.field_22793, this.feedbackMessage, msgX, msgY, 0x55FF55, true);
        } else {
            this.feedbackMessage = null;
        }
    }

    private void renderFullscreenView(class_332 context, int mouseX, int mouseY) {
        int overlayAlpha = (int)((1.0f - this.fadeAlpha) * 200.0f);
        if (overlayAlpha > 0) {
            context.method_25294(0, 0, this.field_22789, this.field_22790, overlayAlpha << 24);
        }
        int availableWidth = this.field_22789 - 80;
        int availableHeight = this.field_22790 - 100;
        int imgWidth = availableWidth;
        int imgHeight = availableHeight;
        float aspectRatio = 1.7777778f;
        if ((float)availableWidth / (float)availableHeight > aspectRatio) {
            imgWidth = (int)((float)availableHeight * aspectRatio);
        } else {
            imgHeight = (int)((float)availableWidth / aspectRatio);
        }
        int imgX = (this.field_22789 - imgWidth) / 2;
        int imgY = 40;
        if (this.fadeAlpha < 1.0f) {
            float scale = 0.9f + 0.1f * this.fadeAlpha;
            int scaledWidth = (int)((float)imgWidth * scale);
            int scaledHeight = (int)((float)imgHeight * scale);
            int scaledX = imgX + (imgWidth - scaledWidth) / 2;
            int scaledY = imgY + (imgHeight - scaledHeight) / 2;
            context.method_25290(class_10799.field_56883, this.selectedImageId, scaledX, scaledY, 0.0f, 0.0f, scaledWidth, scaledHeight, scaledWidth, scaledHeight);
        } else {
            context.method_25290(class_10799.field_56883, this.selectedImageId, imgX, imgY, 0.0f, 0.0f, imgWidth, imgHeight, imgWidth, imgHeight);
        }
        if (this.fadeAlpha > 0.5f) {
            int textAlpha = (int)((this.fadeAlpha - 0.5f) * 2.0f * 255.0f);
            int textColor = textAlpha << 24 | 0xFFFFFF;
            class_5250 nameText = class_2561.method_43470((String)this.selectedImage.getName());
            context.method_51439(this.field_22793, (class_2561)nameText, (this.field_22789 - this.field_22793.method_27525((class_5348)nameText)) / 2, 15, textColor, true);
            if (this.selectedImageIndex >= 0 && this.allScreenshots.length > 0) {
                String counter = this.selectedImageIndex + 1 + " / " + this.allScreenshots.length;
                int counterColor = textAlpha << 24 | 0xAAAAAA;
                context.method_51433(this.field_22793, counter, (this.field_22789 - this.field_22793.method_1727(counter)) / 2, 25, counterColor, true);
            }
        }
    }

    private void renderGalleryView(class_332 context, int mouseX, int mouseY) {
        String titleStr = "Screenshot Gallery (" + this.allScreenshots.length + " screenshots)";
        context.method_25300(this.field_22793, titleStr, this.field_22789 / 2, 10, 0xFFFFFF);
        if (this.allScreenshots.length == 0) {
            String emptyMsg = "No screenshots found";
            int emptyMsgWidth = this.field_22793.method_1727(emptyMsg);
            int centerY = this.field_22790 / 2 - 20;
            context.method_51433(this.field_22793, emptyMsg, (this.field_22789 - emptyMsgWidth) / 2, centerY, 0xAAAAAA, true);
            String hintMsg = "Press F2 in-game to take a screenshot";
            int hintMsgWidth = this.field_22793.method_1727(hintMsg);
            context.method_51433(this.field_22793, hintMsg, (this.field_22789 - hintMsgWidth) / 2, centerY + 15, 0x666666, true);
            return;
        }
        int totalRowWidth = this.getColumns() * (this.getThumbSize() + 10);
        int startX = (this.field_22789 - totalRowWidth) / 2;
        for (int i = 0; i < this.allScreenshots.length; ++i) {
            boolean isHovered;
            int row = i / this.getColumns();
            int col = i % this.getColumns();
            int imgX = startX + col * (this.getThumbSize() + 10);
            int imgY = 32 + row * (this.getThumbSize() + 10) - this.scrollOffset;
            if (imgY + this.getThumbSize() < 32 || imgY > this.field_22790 - 50) continue;
            File file = this.allScreenshots[i];
            class_2960 texId = this.getOrLoadTexture(file);
            boolean bl = isHovered = mouseX >= imgX && mouseX <= imgX + this.getThumbSize() && mouseY >= imgY && mouseY <= imgY + this.getThumbSize() && mouseY >= 32 && mouseY < this.field_22790 - 50;
            if (isHovered) {
                context.method_25294(imgX - 2, imgY - 2, imgX + this.getThumbSize() + 2, imgY + this.getThumbSize() + 2, -1);
            } else {
                context.method_25294(imgX - 1, imgY - 1, imgX + this.getThumbSize() + 1, imgY + this.getThumbSize() + 1, -12303292);
            }
            if (texId != null) {
                context.method_25290(class_10799.field_56883, texId, imgX, imgY, 0.0f, 0.0f, this.getThumbSize(), this.getThumbSize(), this.getThumbSize(), this.getThumbSize());
            } else {
                context.method_25294(imgX, imgY, imgX + this.getThumbSize(), imgY + this.getThumbSize(), -14540254);
                String loadingText = "...";
                int textWidth = this.field_22793.method_1727(loadingText);
                context.method_51433(this.field_22793, loadingText, imgX + (this.getThumbSize() - textWidth) / 2, imgY + (this.getThumbSize() - 8) / 2, -5592406, false);
            }
            if (!isHovered) continue;
            String fileName = file.getName();
            String dateStr = DATE_FORMAT.format(new Date(file.lastModified()));
            List<class_5250> tooltipLines = List.of(class_2561.method_43470((String)fileName), class_2561.method_43470((String)("\u00a77" + dateStr)));
            context.method_51434(this.field_22793, tooltipLines, mouseX, mouseY);
        }
    }

    public void method_25393() {
        boolean isMouseDown;
        super.method_25393();
        if (this.isFadingIn) {
            this.fadeAlpha += 0.15f;
            if (this.fadeAlpha >= 1.0f) {
                this.fadeAlpha = 1.0f;
                this.isFadingIn = false;
            }
        }
        if (this.isFadingOut) {
            this.fadeAlpha -= 0.15f;
            if (this.fadeAlpha <= 0.0f) {
                this.fadeAlpha = 0.0f;
                this.isFadingOut = false;
                this.selectedImage = null;
                this.selectedImageId = null;
                this.selectedImageIndex = -1;
                this.method_25426();
            }
        }
        long currentTime = System.currentTimeMillis();
        if (this.selectedImage == null && currentTime - this.lastRefreshTime > this.getRefreshIntervalMs()) {
            this.lastRefreshTime = currentTime;
            File screenshotDir = new File(this.field_22787.field_1697, "screenshots");
            if (screenshotDir.exists() && screenshotDir.isDirectory()) {
                int currentCount;
                File[] files = screenshotDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".png"));
                int n = currentCount = files != null ? files.length : 0;
                if (currentCount != this.lastScreenshotCount) {
                    this.lastScreenshotCount = currentCount;
                    this.loadScreenshots();
                }
            }
        }
        boolean bl = isMouseDown = GLFW.glfwGetMouseButton((long)this.field_22787.method_22683().method_4490(), (int)0) == 1;
        if (isMouseDown && !this.wasMouseDown && this.selectedImage == null && !this.isFadingOut) {
            double mouseX = this.field_22787.field_1729.method_1603() * (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480();
            double mouseY = this.field_22787.field_1729.method_1604() * (double)this.field_22787.method_22683().method_4502() / (double)this.field_22787.method_22683().method_4507();
            this.handleThumbnailClick(mouseX, mouseY);
        }
        this.wasMouseDown = isMouseDown;
        if (this.selectedImage == null) {
            if (GLFW.glfwGetKey((long)this.field_22787.method_22683().method_4490(), (int)267) == 1) {
                this.scrollOffset = Math.min(this.maxScrollOffset, this.scrollOffset + 20);
            }
            if (GLFW.glfwGetKey((long)this.field_22787.method_22683().method_4490(), (int)266) == 1) {
                this.scrollOffset = Math.max(0, this.scrollOffset - 20);
            }
            if (GLFW.glfwGetKey((long)this.field_22787.method_22683().method_4490(), (int)264) == 1) {
                this.scrollOffset = Math.min(this.maxScrollOffset, this.scrollOffset + 5);
            }
            if (GLFW.glfwGetKey((long)this.field_22787.method_22683().method_4490(), (int)265) == 1) {
                this.scrollOffset = Math.max(0, this.scrollOffset - 5);
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.selectedImage == null) {
            int scrollAmount = (int)(verticalAmount * 30.0);
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void handleThumbnailClick(double mouseX, double mouseY) {
        int totalRowWidth = this.getColumns() * (this.getThumbSize() + 10);
        int startX = (this.field_22789 - totalRowWidth) / 2;
        for (int i = 0; i < this.allScreenshots.length; ++i) {
            int row = i / this.getColumns();
            int col = i % this.getColumns();
            int imgX = startX + col * (this.getThumbSize() + 10);
            int imgY = 32 + row * (this.getThumbSize() + 10) - this.scrollOffset;
            if (imgY + this.getThumbSize() < 32 || imgY > this.field_22790 - 50 || !(mouseX >= (double)imgX) || !(mouseX < (double)(imgX + this.getThumbSize())) || !(mouseY >= (double)imgY) || !(mouseY < (double)(imgY + this.getThumbSize())) || !(mouseY >= 32.0) || !(mouseY < (double)(this.field_22790 - 50))) continue;
            this.openFullscreen(this.allScreenshots[i]);
            return;
        }
    }

    private void openFullscreen(File file) {
        this.selectedImage = file;
        this.selectedImageId = this.getOrLoadTexture(file);
        for (int i = 0; i < this.allScreenshots.length; ++i) {
            if (!this.allScreenshots[i].equals(file)) continue;
            this.selectedImageIndex = i;
            break;
        }
        this.fadeAlpha = 0.0f;
        this.isFadingIn = true;
        this.isFadingOut = false;
        this.method_25426();
    }

    private void closeFullscreen() {
        this.isFadingOut = true;
        this.isFadingIn = false;
    }

    private void navigateImage(int direction) {
        File newFile;
        if (this.allScreenshots.length == 0) {
            return;
        }
        int newIndex = (this.selectedImageIndex + direction + this.allScreenshots.length) % this.allScreenshots.length;
        this.selectedImage = newFile = this.allScreenshots[newIndex];
        this.selectedImageId = this.getOrLoadTexture(newFile);
        this.selectedImageIndex = newIndex;
    }

    private void showFeedback(String message) {
        this.feedbackMessage = message;
        this.feedbackExpiry = System.currentTimeMillis() + 2000L;
    }

    private void confirmDelete() {
        this.wasMouseDown = true;
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed && this.selectedImage != null) {
                class_2960 id = this.textureCache.remove(this.selectedImage);
                if (id != null) {
                    this.field_22787.method_1531().method_4615(id);
                }
                try {
                    Files.deleteIfExists(this.selectedImage.toPath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.selectedImage = null;
                this.selectedImageId = null;
                this.selectedImageIndex = -1;
                this.field_22787.method_1507((class_437)this);
                this.loadScreenshots();
            } else {
                this.field_22787.method_1507((class_437)this);
            }
        }, (class_2561)class_2561.method_43470((String)"Delete Screenshot?"), (class_2561)class_2561.method_43470((String)("Delete \"" + this.selectedImage.getName() + "\"?"))));
    }

    private class_2960 getOrLoadTexture(File file) {
        if (this.textureCache.containsKey(file)) {
            return this.textureCache.get(file);
        }
        if (this.loadingFutures.containsKey(file)) {
            return null;
        }
        CompletionStage future = ImageUtils.loadNativeImageAsync(file).thenAcceptAsync(nativeImage -> {
            if (nativeImage != null) {
                this.field_22787.execute(() -> {
                    class_1043 texture = new class_1043(() -> "gallery_" + file.getName(), nativeImage);
                    String safeName = file.getName().toLowerCase().replaceAll("[^a-z0-9/._-]", "_");
                    class_2960 id = class_2960.method_60655((String)"screenshotgallery", (String)("temp_" + System.currentTimeMillis() + "_" + safeName));
                    this.field_22787.method_1531().method_4616(id, (class_1044)texture);
                    this.textureCache.put(file, id);
                });
            }
            this.loadingFutures.remove(file);
        }, (Executor)this.field_22787);
        this.loadingFutures.put(file, (CompletableFuture<Void>)future);
        return null;
    }

    public void method_25432() {
        this.textureCache.values().forEach(arg_0 -> ((class_1060)this.field_22787.method_1531()).method_4615(arg_0));
        this.textureCache.clear();
    }

    private static enum SortMode {
        DATE_DESC("Newest First"),
        DATE_ASC("Oldest First"),
        NAME_ASC("Name A-Z"),
        NAME_DESC("Name Z-A");

        private final String displayName;

        private SortMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

