/*
 * Decompiled with CFR 0.152.
 */
package net.hicham.screenshotgallery.util;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ImageUtils");

    public static void copyImageToClipboard(File imageFile) {
        if (imageFile == null || !imageFile.exists()) {
            return;
        }
        TransferableImage transferable = new TransferableImage(imageFile);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    public static CompletableFuture<class_1011> loadNativeImageAsync(File file) {
        return CompletableFuture.supplyAsync(() -> {
            class_1011 class_10112;
            FileInputStream inputStream = new FileInputStream(file);
            try {
                class_10112 = class_1011.method_4309((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load image asynchronously: " + file.getAbsolutePath(), (Throwable)e);
                    return null;
                }
            }
            ((InputStream)inputStream).close();
            return class_10112;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static class_1043 loadTexture(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
            if (nativeImage == null) {
                class_1043 class_10432 = null;
                return class_10432;
            }
            class_1043 class_10433 = new class_1043(() -> "gallery_screenshot", nativeImage);
            return class_10433;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load texture from file: " + file.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    private static class TransferableImage
    implements Transferable {
        private final File file;

        public TransferableImage(File file) {
            this.file = file;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.javaFileListFlavor.equals(flavor) || DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                return Collections.singletonList(this.file);
            }
            if (DataFlavor.imageFlavor.equals(flavor)) {
                return ImageIO.read(this.file);
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

