/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.refinedmosaicblocks;

import dev.uraneptus.refinedmosaicblocks.RMBCommon;
import dev.uraneptus.refinedmosaicblocks.content.RMBRegistries;
import dev.uraneptus.refinedmosaicblocks.data.RMBBlockStateProvider;
import dev.uraneptus.refinedmosaicblocks.data.RMBBlockTagsProvider;
import dev.uraneptus.refinedmosaicblocks.data.RMBItemModelProvider;
import dev.uraneptus.refinedmosaicblocks.data.RMBLangProvider;
import dev.uraneptus.refinedmosaicblocks.data.RMBLootProvider;
import dev.uraneptus.refinedmosaicblocks.data.RMBRecipeProvider;
import dev.uraneptus.refinedmosaicblocks.platform.NeoForgeRegHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

@Mod(value="refinedmosaicblocks")
public class NeoRefinedMosaicBlocks {
    public NeoRefinedMosaicBlocks(IEventBus eventBus) {
        RMBCommon.init();
        NeoForgeRegHelper.BLOCKS.register(eventBus);
        NeoForgeRegHelper.ITEMS.register(eventBus);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::gatherData);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        RMBRegistries.initRegIndex();
    }

    public void gatherData(GatherDataEvent event) {
        boolean includeClient = event.includeClient();
        boolean includeServer = event.includeServer();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(includeClient, (DataProvider)new RMBLangProvider(packOutput));
        generator.addProvider(includeClient, (DataProvider)new RMBBlockStateProvider(packOutput, fileHelper));
        generator.addProvider(includeClient, (DataProvider)new RMBItemModelProvider(packOutput, fileHelper));
        generator.addProvider(includeServer, (DataProvider)new RMBLootProvider(packOutput, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new RMBRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(includeServer, (DataProvider)new RMBBlockTagsProvider(packOutput, lookupProvider, fileHelper));
    }

    @Mod(value="refinedmosaicblocks", dist={Dist.CLIENT})
    public static class Client {
        public Client(IEventBus bus, ModContainer modContainer) {
            bus.addListener(this::buildTabContents);
        }

        private void buildTabContents(BuildCreativeModeTabContentsEvent event) {
            ResourceKey tabKey = event.getTabKey();
            RMBRegistries.REG_INDEX.forEach(item -> {
                if (tabKey == CreativeModeTabs.BUILDING_BLOCKS) {
                    event.accept((ItemLike)item, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            });
        }
    }
}

